/**************************************************************************************
* @file         : NavigationSettingsListHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAVIGATION_SETTINGS_LIST_HANDLER_H
#define NAVIGATION_SETTINGS_LIST_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"

#ifdef HALL_TO_MDW_COM

class NavigationSettingsListHandler : public HMIModelBase, public ListImplementation
{
   public:
      NavigationSettingsListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~NavigationSettingsListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from Infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      COURIER_CASE_DUMMY_ENTRY()   // Dummy Case is added to avoid compilation warnings (no : C4065)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ResetAllNaviSettingsReqMsg)
      ON_COURIER_MESSAGE(ApplySettingsReqMsg)
      ON_COURIER_MESSAGE(CheckIsSatelliteSourceChangedReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      bool onCourierMessage(const ResetAllNaviSettingsReqMsg& oMsg);
      bool onCourierMessage(const ApplySettingsReqMsg& oMsg);
      bool onCourierMessage(const CheckIsSatelliteSourceChangedReqMsg& oMsg);

      void resetNaviHmiSettings();
      void configureCarsor();
      void configureRouteOptionsBorder(bool isDayModeActive);

   private:
      enum SatelliteSources
      {
         KDS_SATELLITE_SRC__NO_GNSS = 0,
         KDS_SATELLITE_SRC__GPS_ONLY = 1,
         KDS_SATELLITE_SRC__GPS_AND_GLONASS = 3,
         KDS_SATELLITE_SRC__GPS_AND_GALILEO = 5
      };

      unsigned int _listId;
      DataBindingItem<MultiLinePopuptextDataBindingSource> _PopupText;
      DataBindingItem<RouteOptionsBorderDataBindingSource> _routeOptionsBorder;

      typedef ListItemBase<enOptItems> NavigationSettingsListItem;
      std::vector<NavigationSettingsListItem> _navigationSettingsList;
      enSatelliteSourceOption _currentSatelliteSource;
      enSatelliteSourceOption _previousSatelliteSource;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(NavigationSettingsListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // NAVIGATION_SETTINGS_LIST_HANDLER_H
