/**************************************************************************************
* @file         : NaviSettingsUtil.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAVI_SETTINGS_UTILS_H
#define NAVI_SETTINGS_UTILS_H

#include "CanderaWidget/String/String.h"
#include <string>

#define MAX_DYNAMIC_POPUP_TEXT 2
#define MAX_SIZE_VEHICLE_SETTINGS 9
#define MAX_SIZE_PROFILE_DROP_DOWN_LIST 4
#define MAX_SIZE_PROFILE_DROP_DOWN_LIST_COACH 2
#define MAX_SIZE_HAZARDOUS_DROP_DOWN_LIST 5
#define MAX_SIZE_TRAILER_DROP_DOWN_LIST 4
#define MAX_SIZE_LEFTSIDE_INFO_DROPDOWN 2
#define MAX_SIZE_DUALMAPVIEW_DROPDOWN 4
#define MAX_SIZE_MAPORIENTAION_DROPDOWN 2
#define MAX_SIZE_MAP_TEXT 3
#define MAX_SIZE_NAVIGATION_SETTINGS_LIST 9
#define MAX_SIZE_TRACKING_DOTS_TEXT_ID 4
#define MAX_SIZE_TRACKING_DOTS_TEXT 2
#define MAX_SIZE_USE_TRAFFIC_INFO 3
#define MAX_SIZE_ROUTE_SETTING_OTHERS_LIST 11
#define MAX_SIZE_ROUTE_TYPE 3
#define MAX_SIZE_CUSTOM_ROUTE_OPTION 2
#define MAX_SIZE_ESTIMATED_TIME 2
#define MAX_SIZE_TIME_ON_MAP 2
#define MAX_SIZE_ROUTE_PREFERENCE_LIST 5
#define MAX_SIZE_DEST_ADDRESS_DEFAULT_VALUE 6
#define MAX_SIZE_STREAM_MAP_TIMER_DURATION 4
#define MAX_SIZE_PREMIUM_TRAFFIC_DROP_DOWN_LIST 6
#define MAX_SIZE_MYPOI_LIST 3
#define MAX_SIZE_MAPSETTINGS_LIST 5
#define MAX_SIZE_GUIDANCE_VIEW_OPTION 2
#define MAX_SIZE_MAPSETTING_OTHER_LIST 12
#define MAX_LIST_LEFT_SPLIT_SIZE 3
#define MAX_LIST_TRACKING_DOT 3
#define MAX_LIST_SATELLITE_SOURCE 2

extern std::string DynamicPopupText[MAX_DYNAMIC_POPUP_TEXT];
extern Candera::String LeftSideInfoDropDownListLabel[MAX_SIZE_LEFTSIDE_INFO_DROPDOWN];
extern Candera::String DualMapViewDropDownListLabel[MAX_SIZE_DUALMAPVIEW_DROPDOWN];
extern Candera::String MapOrientaionDropDownListLabel[MAX_SIZE_MAPORIENTAION_DROPDOWN];
extern Candera::String MapTextSizeListLabel[MAX_SIZE_MAP_TEXT];
extern Candera::String NavigationSettings_ListItemText[MAX_SIZE_NAVIGATION_SETTINGS_LIST];
extern Candera::String TrackingDotsDistance[MAX_SIZE_TRACKING_DOTS_TEXT_ID][MAX_SIZE_TRACKING_DOTS_TEXT];
extern Candera::String UseTrafficInfoStrings[MAX_SIZE_USE_TRAFFIC_INFO];
extern Candera::String RouteSettingOthers_ListItemText[MAX_SIZE_ROUTE_SETTING_OTHERS_LIST];

extern Candera::String VehicleSettingsLabel[MAX_SIZE_VEHICLE_SETTINGS];
extern Candera::String ProfileDropDownListLabel[MAX_SIZE_PROFILE_DROP_DOWN_LIST];
extern Candera::String ProfileDropDownListLabelCoach[MAX_SIZE_PROFILE_DROP_DOWN_LIST_COACH];
extern Candera::String HazardousDropDownListLabel[MAX_SIZE_HAZARDOUS_DROP_DOWN_LIST];
extern Candera::String TrailerTypeDropDownListLabel[MAX_SIZE_TRAILER_DROP_DOWN_LIST];
extern Candera::String RouteTypeStrings[MAX_SIZE_ROUTE_TYPE];
extern Candera::String CustomRouteOptionStrings[MAX_SIZE_CUSTOM_ROUTE_OPTION];
extern Candera::String EstimatedTimeStrings[MAX_SIZE_ESTIMATED_TIME];
extern Candera::String TimeOnMapStrings[MAX_SIZE_TIME_ON_MAP];
extern Candera::String RoutePreference_ListItemText[MAX_SIZE_ROUTE_PREFERENCE_LIST];
extern Candera::String DEST_ADDRESS_DEFAULT_VALUE[MAX_SIZE_DEST_ADDRESS_DEFAULT_VALUE];
extern Candera::String StreamMapTimerDuration[MAX_SIZE_STREAM_MAP_TIMER_DURATION];
extern Candera::String PremiumTrafficDropDownListLabel[MAX_SIZE_PREMIUM_TRAFFIC_DROP_DOWN_LIST];
extern Candera::String MyPOIListItemText[MAX_SIZE_MYPOI_LIST];
extern Candera::String MapSettingsListItemText[MAX_SIZE_MAPSETTINGS_LIST];
extern Candera::String MapOtherSettingsListItemText[MAX_SIZE_MAPSETTING_OTHER_LIST];
extern Candera::String LeftSplitMapSettingsListItemText[MAX_LIST_LEFT_SPLIT_SIZE];
extern Candera::String TrackingDotSettingsListItemText[MAX_LIST_TRACKING_DOT];
extern Candera::String SatelliteSourceDropDownListLabel[MAX_LIST_SATELLITE_SOURCE];
extern Candera::String LengthText;
extern Candera::String HeightText;
extern Candera::String WidthText;
extern Candera::String WeightText;
extern Candera::String WeightPerAxleText;
extern Candera::String GoodsTypeText;
void initNaviSettingsTextIDs();
std::string replaceInTranslationTextID(std::string inputText, std::string textToReplace, std::string replacementText);

#endif
