/**************************************************************************************
* @file         : NaviSettingsUtil.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "NaviSettingsUtil.h"
#include "Common/Util/HMIModelIncludes.h"

const int INVALID_VALUE = 0xFFFF;
std::string DynamicPopupText[MAX_DYNAMIC_POPUP_TEXT];
Courier::ViewId currentOpenedDropDownSceneName = Courier::ViewId("");
Candera::String LeftSideInfoDropDownListLabel[MAX_SIZE_LEFTSIDE_INFO_DROPDOWN];
Candera::String DualMapViewDropDownListLabel[MAX_SIZE_DUALMAPVIEW_DROPDOWN];
Candera::String MapOrientaionDropDownListLabel[MAX_SIZE_MAPORIENTAION_DROPDOWN];
Candera::String MapTextSizeListLabel[MAX_SIZE_MAP_TEXT];
Candera::String NavigationSettings_ListItemText[MAX_SIZE_NAVIGATION_SETTINGS_LIST];
Candera::String TrackingDotsDistance[MAX_SIZE_TRACKING_DOTS_TEXT_ID][MAX_SIZE_TRACKING_DOTS_TEXT];
Candera::String UseTrafficInfoStrings[MAX_SIZE_USE_TRAFFIC_INFO];
Candera::String RouteSettingOthers_ListItemText[MAX_SIZE_ROUTE_SETTING_OTHERS_LIST];
Candera::String VehicleSettingsLabel[MAX_SIZE_VEHICLE_SETTINGS];
Candera::String ProfileDropDownListLabel[MAX_SIZE_PROFILE_DROP_DOWN_LIST];
Candera::String ProfileDropDownListLabelCoach[MAX_SIZE_PROFILE_DROP_DOWN_LIST_COACH];
Candera::String HazardousDropDownListLabel[MAX_SIZE_HAZARDOUS_DROP_DOWN_LIST];
Candera::String TrailerTypeDropDownListLabel[MAX_SIZE_TRAILER_DROP_DOWN_LIST];
Candera::String RouteTypeStrings[MAX_SIZE_ROUTE_TYPE];
Candera::String CustomRouteOptionStrings[MAX_SIZE_CUSTOM_ROUTE_OPTION];
Candera::String EstimatedTimeStrings[MAX_SIZE_ESTIMATED_TIME];
Candera::String TimeOnMapStrings[MAX_SIZE_TIME_ON_MAP];
Candera::String RoutePreference_ListItemText[MAX_SIZE_ROUTE_PREFERENCE_LIST];
Candera::String DEST_ADDRESS_DEFAULT_VALUE[MAX_SIZE_DEST_ADDRESS_DEFAULT_VALUE];
Candera::String StreamMapTimerDuration[MAX_SIZE_STREAM_MAP_TIMER_DURATION];
Candera::String PremiumTrafficDropDownListLabel[MAX_SIZE_PREMIUM_TRAFFIC_DROP_DOWN_LIST];
Candera::String MyPOIListItemText[MAX_SIZE_MYPOI_LIST];
Candera::String MapSettingsListItemText[MAX_SIZE_MAPSETTINGS_LIST];
Candera::String MapOtherSettingsListItemText[MAX_SIZE_MAPSETTING_OTHER_LIST];
Candera::String LeftSplitMapSettingsListItemText[MAX_LIST_LEFT_SPLIT_SIZE];
Candera::String TrackingDotSettingsListItemText[MAX_LIST_TRACKING_DOT];
Candera::String SatelliteSourceDropDownListLabel[MAX_LIST_SATELLITE_SOURCE];
Candera::String LengthText;
Candera::String HeightText;
Candera::String WidthText;
Candera::String WeightText;
Candera::String WeightPerAxleText;
Candera::String GoodsTypeText;

void initNaviSettingsTextIDs()
{
   DynamicPopupText[0] = "%1";
   DynamicPopupText[1] = "%2";

   //"Intersection", "Turn list", "Turn list", "Full map"
   LeftSideInfoDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13EC, "Intersection");
   LeftSideInfoDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13ED, "Full map");

   //      "2D Map", "Split: 2D Map", "3D Map", "Split: 3D Map"
   DualMapViewDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13E8, "2D Map");
   DualMapViewDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13E9, "Split: 2D map");
   DualMapViewDropDownListLabel[2] = LANGUAGE_STRING(TextId_0x13EA, "3D map");
   DualMapViewDropDownListLabel[3] = LANGUAGE_STRING(TextId_0x13EB, "Split 3D map");

   // "North up", "Heading up"

   MapOrientaionDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13EF, "North up");
   MapOrientaionDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13F0, "Heading up");

   //   "Small", "Medium", "Large"
   MapTextSizeListLabel[0] = LANGUAGE_STRING(TextId_0x13CD, "Small");
   MapTextSizeListLabel[1] = LANGUAGE_STRING(TextId_0x13CC, "Medium");
   MapTextSizeListLabel[2] = LANGUAGE_STRING(TextId_0x13CB, "Large");

   //   Navigation settings
   NavigationSettings_ListItemText[0] = LANGUAGE_STRING(TextId_0x142E, "Route preferences");
   NavigationSettings_ListItemText[1] = LANGUAGE_STRING(TextId_0x13E5, "Map settings");
   NavigationSettings_ListItemText[2] = LANGUAGE_STRING(TextId_0x13FA, "Guidance and Safety settings");
   NavigationSettings_ListItemText[3] = LANGUAGE_STRING(TextId_0x1402, "Traffic information settings");
   NavigationSettings_ListItemText[4] = LANGUAGE_STRING(TextId_0x0394, "Position and GPS info");
   NavigationSettings_ListItemText[5] = LANGUAGE_STRING(TextId_0x035E, "My POIs");
   NavigationSettings_ListItemText[6] = LANGUAGE_STRING(TextId_0x13CE, "Vehicle settings");
   //Disable Stream Map option from settings
   //NavigationSettings_ListItemText[7] = LANGUAGE_STRING(TextId_0x1451, "Secondary map settings");
   NavigationSettings_ListItemText[7] = LANGUAGE_STRING(TextId_0x19A3, "Satellite source");
   NavigationSettings_ListItemText[8] = LANGUAGE_STRING(TextId_0x1415, "Reset all navigation settings to default");

   //{
   //   { "50 m", "1/32 miles" },
   //   { "100 m", "1/16 miles" },
   //   { "200 m", "1/8 miles" },
   //   { "400 m", "1/4 miles" }
   //};
   TrackingDotsDistance[0][0] = LANGUAGE_STRING(TextId_0x140C, "50 m");
   TrackingDotsDistance[0][1] = LANGUAGE_STRING(TextId_0x1410, "1/32 miles");
   TrackingDotsDistance[1][0] = LANGUAGE_STRING(TextId_0x140D, "100 m");
   TrackingDotsDistance[1][1] = LANGUAGE_STRING(TextId_0x1411, "1/16 miles");
   TrackingDotsDistance[2][0] = LANGUAGE_STRING(TextId_0x140E, "200 m");
   TrackingDotsDistance[2][1] = LANGUAGE_STRING(TextId_0x1412, "1/8 miles");
   TrackingDotsDistance[3][0] = LANGUAGE_STRING(TextId_0x140F, "400 m");
   TrackingDotsDistance[3][1] = LANGUAGE_STRING(TextId_0x1413, "1/4 miles");

   // { "Auto", "Accept", "Off" };
   UseTrafficInfoStrings[0] = LANGUAGE_STRING(TextId_0x141C, "Always");
   UseTrafficInfoStrings[1] = LANGUAGE_STRING(TextId_0x1429, "Prompt");
   UseTrafficInfoStrings[2] = LANGUAGE_STRING(TextId_0x1445, "Never");

   RouteSettingOthers_ListItemText[0] = LANGUAGE_STRING(TextId_0x1401, "Use traffic information");
   RouteSettingOthers_ListItemText[1] = LANGUAGE_STRING(TextId_0x143D, "Use toll roads");
   RouteSettingOthers_ListItemText[2] = LANGUAGE_STRING(TextId_0x13FF, "Minimise ferries");
   RouteSettingOthers_ListItemText[3] = LANGUAGE_STRING(TextId_0x039C, "Minimise train transport");
   RouteSettingOthers_ListItemText[4] = LANGUAGE_STRING(TextId_0x14ED, "Minimise subscription roads");
   RouteSettingOthers_ListItemText[5] = LANGUAGE_STRING(TextId_0x1442, "Minimise unverified roads");
   RouteSettingOthers_ListItemText[6] = LANGUAGE_STRING(TextId_0x143E, "Minimise unpaved roads");
   RouteSettingOthers_ListItemText[7] = LANGUAGE_STRING(TextId_0x143F, "Minimise HOV lanes");
   RouteSettingOthers_ListItemText[8] = LANGUAGE_STRING(TextId_0x1440, "Avoid border crossing");
   RouteSettingOthers_ListItemText[9] = LANGUAGE_STRING(TextId_0x1441, "Avoid U-turns");
   RouteSettingOthers_ListItemText[10] = LANGUAGE_STRING(TextId_0x1446, "Avoid tunnels");

   //      Vehicle settings
   LengthText    = LANGUAGE_STRING(TextId_0x13DA, "Length");
   HeightText    = LANGUAGE_STRING(TextId_0x13D9, "Height");
   WidthText     = LANGUAGE_STRING(TextId_0x13DB, "Width");
   WeightText    = LANGUAGE_STRING(TextId_0x13DC, "Total weight (metric tons)");
   WeightPerAxleText = LANGUAGE_STRING(TextId_0x13E0, "Load per axle (metric tons)");
   GoodsTypeText = LANGUAGE_STRING(TextId_0x13E2, "Goods type");
   VehicleSettingsLabel[0] = LANGUAGE_STRING(TextId_0x13D8, "Profile");
   VehicleSettingsLabel[1] = HeightText;
   VehicleSettingsLabel[2] = LengthText;
   VehicleSettingsLabel[3] = WidthText;
   VehicleSettingsLabel[4] = WeightText;
   VehicleSettingsLabel[5] = WeightPerAxleText;
   VehicleSettingsLabel[6] = LANGUAGE_STRING(TextId_0x13E1, "Maximum speed");
   VehicleSettingsLabel[7] = LANGUAGE_STRING(TextId_0x13DD, "Trailer type");
   VehicleSettingsLabel[8] = GoodsTypeText;

   //      Vehicle profile types for truck

   ProfileDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13D0, "Profile 1");
   ProfileDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13D1, "Profile 2");
   ProfileDropDownListLabel[2] = LANGUAGE_STRING(TextId_0x13D2, "Profile 3");
   ProfileDropDownListLabel[3] = LANGUAGE_STRING(TextId_0x13CF, "Default");

   //      Vehicle profile types for coach

   ProfileDropDownListLabelCoach[0] = LANGUAGE_STRING(TextId_0x1C05, "Coach");

   //   Type of good loaded in truck

   HazardousDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13D3, "No load");
   HazardousDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13D4, "No hazardous");
   HazardousDropDownListLabel[2] = LANGUAGE_STRING(TextId_0x13D5, "Water polluting");
   HazardousDropDownListLabel[3] = LANGUAGE_STRING(TextId_0x13D6, "Explosives");
   HazardousDropDownListLabel[4] = LANGUAGE_STRING(TextId_0x13D7, "Gas");

   //      Trailer type for Trucks

   TrailerTypeDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x13E3, "No trailer");
   TrailerTypeDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x13CD, "Small");
   TrailerTypeDropDownListLabel[2] = LANGUAGE_STRING(TextId_0x13CC, "Medium");
   TrailerTypeDropDownListLabel[3] = LANGUAGE_STRING(TextId_0x13CB, "Large");

   //"Fastest", "Optimised", "Shortest" }

   RouteTypeStrings[0] = LANGUAGE_STRING(TextId_0x066A, "Shortest");
   RouteTypeStrings[1] = LANGUAGE_STRING(TextId_0x066C, "Fastest");
   RouteTypeStrings[2] = LANGUAGE_STRING(TextId_0x066B, "Optimised");

   CustomRouteOptionStrings[0] = LANGUAGE_STRING(TextId_0x143C, "Single");
   CustomRouteOptionStrings[1] = LANGUAGE_STRING(TextId_0x143B, "Multiple");

   EstimatedTimeStrings[0] = LANGUAGE_STRING(TextId_0x13CA, "Destination");
   EstimatedTimeStrings[1] = LANGUAGE_STRING(TextId_0x13FC, "Waypoint");

   TimeOnMapStrings[0] = LANGUAGE_STRING(TextId_0x142B, "ETA");
   TimeOnMapStrings[1] = LANGUAGE_STRING(TextId_0x1456, "Duration");

   RoutePreference_ListItemText[0] = LANGUAGE_STRING(TextId_0x13FE, "Route criteria");
   RoutePreference_ListItemText[1] = LANGUAGE_STRING(TextId_0x1455, "Route options");
   RoutePreference_ListItemText[2] = LANGUAGE_STRING(TextId_0x141E, "Route type");
   RoutePreference_ListItemText[3] = LANGUAGE_STRING(TextId_0x13FB, "Estimated time");
   RoutePreference_ListItemText[4] = LANGUAGE_STRING(TextId_0x142A, "Time shown on map");

   DEST_ADDRESS_DEFAULT_VALUE[0] = LANGUAGE_STRING(TextId_0x0F5C, "Country");
   DEST_ADDRESS_DEFAULT_VALUE[1] = LANGUAGE_STRING(TextId_0x0482, "State");
   DEST_ADDRESS_DEFAULT_VALUE[2] = LANGUAGE_STRING(TextId_0x0F59, "City/PostCode");
   DEST_ADDRESS_DEFAULT_VALUE[3] = LANGUAGE_STRING(TextId_0x0B5B, "Street");
   DEST_ADDRESS_DEFAULT_VALUE[4] = LANGUAGE_STRING(TextId_0x0B5E, "HouseNumber");
   DEST_ADDRESS_DEFAULT_VALUE[5] = LANGUAGE_STRING(TextId_0x0B5F, "Intersection");

   StreamMapTimerDuration[0] = LANGUAGE_STRING(TextId_0x149B, "30 sec");
   StreamMapTimerDuration[1] = LANGUAGE_STRING(TextId_0x149C, "40 sec");
   StreamMapTimerDuration[2] = LANGUAGE_STRING(TextId_0x149D, "50 sec");
   StreamMapTimerDuration[3] = LANGUAGE_STRING(TextId_0x149E, "60 sec");

   PremiumTrafficDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x1493, "Do not update");
   PremiumTrafficDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x1494, "Once every 2 min");
   PremiumTrafficDropDownListLabel[2] = LANGUAGE_STRING(TextId_0x1495, "Once every 5 min");
   PremiumTrafficDropDownListLabel[3] = LANGUAGE_STRING(TextId_0x1772, "Once every 10 min");
   PremiumTrafficDropDownListLabel[4] = LANGUAGE_STRING(TextId_0x1496, "Once every 30 min");
   PremiumTrafficDropDownListLabel[5] = LANGUAGE_STRING(TextId_0x1497, "Once every 60 min");

   MyPOIListItemText[0] = LANGUAGE_STRING(TextId_0x0367, "POI warning");
   MyPOIListItemText[1] = LANGUAGE_STRING(TextId_0x197D, "Download from USB flash drive");
   MyPOIListItemText[2] = LANGUAGE_STRING(TextId_0x038A, "Delete MyPOIs");

   MapSettingsListItemText[0] = LANGUAGE_STRING(TextId_0x13E7, "Map view");
   MapSettingsListItemText[1] = LANGUAGE_STRING(TextId_0x1420, "Guidance view");
   MapSettingsListItemText[2] = LANGUAGE_STRING(TextId_0x036A, "Show POIs on map");
   MapSettingsListItemText[3] = LANGUAGE_STRING(TEXTID_UNAVAILABLE, "Duration and ETA on passenger map");
   MapSettingsListItemText[4] = LANGUAGE_STRING(TextId_0x1404, "More options");

   MapOtherSettingsListItemText[0] = LANGUAGE_STRING(TextId_0x0365, "Map orientation");
   MapOtherSettingsListItemText[1] = LANGUAGE_STRING(TextId_0x13F8, "Left split map settings");
   MapOtherSettingsListItemText[2] = LANGUAGE_STRING(TextId_0x13F3, "Map text size");
   MapOtherSettingsListItemText[3] = LANGUAGE_STRING(TextId_0x13F2, "Map color");
   MapOtherSettingsListItemText[4] = LANGUAGE_STRING(TextId_0x13F4, "Select text to display on map");
   MapOtherSettingsListItemText[5] = LANGUAGE_STRING(TextId_0x1405, "Map scrolling information");
   MapOtherSettingsListItemText[6] = LANGUAGE_STRING(TextId_0x1409, "Tracking dots displayed on map");
   MapOtherSettingsListItemText[7] = LANGUAGE_STRING(TextId_0x13F1, "Long range");
   MapOtherSettingsListItemText[8] = LANGUAGE_STRING(TEXTID_UNAVAILABLE, "Show all freeway exit on route");
   MapOtherSettingsListItemText[9] = LANGUAGE_STRING(TEXTID_UNAVAILABLE, "Auto : show turn list on freeway");
   MapOtherSettingsListItemText[10] = LANGUAGE_STRING(TEXTID_UNAVAILABLE, "North up when zoomed out");
   MapOtherSettingsListItemText[11] = LANGUAGE_STRING(TextId_0x1436, "Auto zoom");

   LeftSplitMapSettingsListItemText[0] = LANGUAGE_STRING(TextId_0x13EE, "Map orientation");
   LeftSplitMapSettingsListItemText[1] = LANGUAGE_STRING(TextId_0x13F9, "Map scale");
   LeftSplitMapSettingsListItemText[2] = LANGUAGE_STRING(TextId_0x13F1, "Long range");

   TrackingDotSettingsListItemText[0] = LANGUAGE_STRING(TextId_0x140A, "Show tracking dots on map");
   TrackingDotSettingsListItemText[1] = LANGUAGE_STRING(TextId_0x140B, "Distance between tracking dots");
   TrackingDotSettingsListItemText[2] = LANGUAGE_STRING(TextId_0x1452, "Delete tracking dots");

   SatelliteSourceDropDownListLabel[0] = LANGUAGE_STRING(TextId_0x19A5, "GPS + GLONASS");
   SatelliteSourceDropDownListLabel[1] = LANGUAGE_STRING(TextId_0x19A6, "GPS + GALILEO");
}


std::string replaceInTranslationTextID(std::string inputText, std::string textToReplace, std::string replacementText)
{
   if (inputText.find(textToReplace) != std::string::npos)
   {
      inputText.replace(inputText.find(textToReplace), textToReplace.size(), replacementText);
   }
   return inputText;
}
