/***************************************************************************
* Copyright(c) -2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
//#include "Common/Util/HMIModelTypes.h"
//#include "gui_std_if.h"
//extern IsButtonToggleEnabled;
#include "MapSettingsOthersUtil.h"
#include "NaviSettingsUtil.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapSettingsLeftSplitMapListHandler.cpp.trc.h"
#endif

IsButtonToggleEnabled getMapLeftViewLongeRange(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapSettings().isMapSecondaryViewLongRangeEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getMapLeftViewLongeRange(%d)", retValue));
   return retValue;
}


IsButtonToggleEnabled getLongRange(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapSettings().isMapLongRangeEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getLongeRange(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getFreewayExitOnRoute(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapSettings().isShowAllFreewayExitsOnMapEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getFreewayExitOnRoute(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getAutoTurnList(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapSettings().isAutoShowTurnListOnFreewayEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getAutoTurnList(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getNorthUPWhenZoomedOut(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapSettings().isNorthUpZoomOutEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getNorthUPWhenZoomedOut(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getAutoZoom(navmiddleware::NavMiddleware&  navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapSettings().isAutoZoomEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getAutoZoom(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getPlaceNames(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = navMiddleware.getMapTextFilterSettings().isPlaceNameFilterEnabled()
                                    ? BUTTON_TOGGLE_ENABLED_TRUE : BUTTON_TOGGLE_ENABLED_FALSE;
   //ETG_TRACE_USR4(("getPlaceNames(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getFacilityNames(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = navMiddleware.getMapTextFilterSettings().isFacilityNameFilterEnabled()
                                    ? BUTTON_TOGGLE_ENABLED_TRUE : BUTTON_TOGGLE_ENABLED_FALSE;
   //ETG_TRACE_USR4(("getFacilityNames(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getRoadNames(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = navMiddleware.getMapTextFilterSettings().isRoadNameFilterEnabled()
                                    ? BUTTON_TOGGLE_ENABLED_TRUE : BUTTON_TOGGLE_ENABLED_FALSE;
   //ETG_TRACE_USR4(("getRoadNames(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getAdressBookIcon(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapDetailTriggerSettings().isAddressBookIconsEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getAdressBookIcon(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getTmcTrafficIcon(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapDetailTriggerSettings().isTMCTrafficIconsEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getTmcTrafficIcon(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getDestWayPointIcon(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapDetailTriggerSettings().isDestinationWaypointIconsEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getDestWayPointIcon(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getPOPUPPOIIcon(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapDetailTriggerSettings().isShowPopUpForPOIsEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getPOPUPPOIIcon(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getLatLongIcon(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;;
   if (navMiddleware.getMapDetailTriggerSettings().isLatLongInfoEnabled())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getLongeRange(%d)", retValue));

   return retValue;
}


IsButtonToggleEnabled getTrackingDotsOnMap(navmiddleware::NavMiddleware& navMiddleware)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (navMiddleware.getMapTrackingDotsSettings().getTrackingDotDisplayState())
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   //ETG_TRACE_USR4(("getTrackingDotsOnMap(%d)", retValue));
   return retValue;
}


IsButtonToggleEnabled toggleCheckbox(IsButtonToggleEnabled currentCheckBoxValue)
{
   IsButtonToggleEnabled retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   if (BUTTON_TOGGLE_ENABLED_TRUE == currentCheckBoxValue)
   {
      retValue = BUTTON_TOGGLE_ENABLED_FALSE;
   }
   else
   {
      retValue = BUTTON_TOGGLE_ENABLED_TRUE;
   }

   return retValue;
}


Candera::String getMapOrientation(navmiddleware::NavMiddleware& navMiddleware, bool IsLeftMapOrientation)
{
   Candera::String retValue = "";

   navmiddleware::settings::MapOrientation mapOrientation = (IsLeftMapOrientation == false) ? navMiddleware.getMapSettings().getMapOrientation() : navMiddleware.getMapSettings().getMapSecondaryViewOrientation();
   switch (mapOrientation)
   {
      case navmiddleware::settings::MAP_ORIENTATION_NORTH_UP:
         retValue = MapOrientaionDropDownListLabel[0];
         break;
      case navmiddleware::settings::MAP_ORIENTATION_HEAD_UP:
         retValue = MapOrientaionDropDownListLabel[1];
         break;
      default:
         retValue = MapOrientaionDropDownListLabel[0];
         break;
   }

   return retValue;
}
