/**************************************************************************************
* @file         : MapColorStyleListHandler.cpp
* @author       : ECG-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include <vector>
#include "MapColorStyleListHandler.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/MapColorStyleListHandler.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)

MapColorStyleListHandler::MapColorStyleListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : NavMiddlewarePropertyUpdateConsumer(navMiddleware)
{
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_MAP_SETTINGS_MAP_COLOR, this);
}


MapColorStyleListHandler::~MapColorStyleListHandler()
{
}


void MapColorStyleListHandler::initialize()
{
   const Candera::UInt8 MAX_LIST_SIZE = 4;
   navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
   navmiddleware::settings::MapColorStyle mapColorStyle = mapSettings.getMapColorStyle();
   mapSettings.setMapColorStyle(mapColorStyle);

   _mapColorStyleList.reserve(MAX_LIST_SIZE);
   _mapColorStyleList.push_back(MapColorStyleListItem(LANGUAGE_STRING(TextId_0x1437, "Standard"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_1));
   _mapColorStyleList.push_back(MapColorStyleListItem(LANGUAGE_STRING(TextId_0x1438, "Emphasise roads"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_2));
   _mapColorStyleList.push_back(MapColorStyleListItem(LANGUAGE_STRING(TextId_0x1439, "Emphasise text"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_3));
   _mapColorStyleList.push_back(MapColorStyleListItem(LANGUAGE_STRING(TextId_0x143A, "Emphasize traffic jams"), IS_VISIBLE_TRUE, LIST_BUTTON_TYPE_BUTTON, MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_4));
}


void MapColorStyleListHandler::deinitialize()
{
}


bool MapColorStyleListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool listUpdateNeeded = false;
   Candera::UInt32 listId = oMsg.GetListId();
   unsigned int rowID = (unsigned int)oMsg.GetHdl();
   const enReaction reaction = oMsg.GetReaction();
   if ((LIST_ID_MAP_SETTINGS_MAP_COLOR == listId) && (enRelease == reaction))
   {
      navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
      ETG_TRACE_USR4(("MapColorStyleListHandler::onCourierMessage(ButtonListItemUpdMsg(listID %d, row %d))", listId, rowID));

      switch (rowID)
      {
         case MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_1: // Color 1
         {
            mapSettings.setMapColorStyle(navmiddleware::settings::MAPCOLORSTYLE_TYPE_1);
            listUpdateNeeded = true;
            break;
         }
         case MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_2: // Color 2
         {
            mapSettings.setMapColorStyle(navmiddleware::settings::MAPCOLORSTYLE_TYPE_2);
            listUpdateNeeded = true;
            break;
         }
         case MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_3: // Color 3
         {
            mapSettings.setMapColorStyle(navmiddleware::settings::MAPCOLORSTYLE_TYPE_3);
            listUpdateNeeded = true;
            break;
         }
         case MAP_COLOR_STYLE_LIST_ITEM_SPEED_COLOR_4: // Color 4
         {
            mapSettings.setMapColorStyle(navmiddleware::settings::MAPCOLORSTYLE_TYPE_4);
            listUpdateNeeded = true;
            break;
         }
         default:
         {
            break;
         }
      }
      _navMiddleware.updateMapSettings(mapSettings);
      if (listUpdateNeeded == true)
      {
         ListRegistry::s_getInstance().updateList(LIST_ID_MAP_SETTINGS_MAP_COLOR);
         _navMiddleware.applySettings();
      }
   }
   return listUpdateNeeded;
}


tSharedPtrDataProvider MapColorStyleListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_USR4(("MapColorStyleListHandler::getListDataProvider()"));
   DataItemContext listItemName = "Layer_ListButton";
   ListDataProviderBuilder listBuilder(LIST_ID_MAP_SETTINGS_MAP_COLOR);

   navmiddleware::settings::MapSettings mapSettings = _navMiddleware.getMapSettings();
   navmiddleware::settings::MapColorStyle mapColorStyleId = mapSettings.getMapColorStyle();
   bool isSelected = false;
   for (std::vector<MapColorStyleListItem>::iterator itemNumber = _mapColorStyleList.begin(); itemNumber < _mapColorStyleList.end(); ++itemNumber)
   {
      bool isSelected = false;

      //Highlight selected map color
      int selectedMapColorStyleId = (int)itemNumber->_order;
      if ((int)mapColorStyleId == selectedMapColorStyleId)   // Typecasted to int to avoid coverity warning in enum comparison
      {
         isSelected = true;
      }

      if (itemNumber->_listButtonType == LIST_BUTTON_TYPE_BUTTON)
      {
         listBuilder.AddItem(
            itemNumber->_order,
            0UL,  //    - unused
            listItemName)  //0 - Name(Id) of the button
         .AddData(itemNumber->_text)
         .AddData(isSelected);
      }
   }

   return listBuilder.CreateDataProvider();
}


#endif // HALL_TO_MDW_COM
