/**************************************************************************************
* @file         : HMIModelPosition.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_POSITION_H
#define HMI_MODEL_POSITION_H

#include "Common/Util/HMIModelIncludes.h"
#if defined(HALL_TO_MDW_COM)

class HMIModelPosition : public HMIModelBase
{
   public:
      HMIModelPosition(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelPosition();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_SENSORINFO_CHANGED, onPropertyUpdateGPSSensorStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_WHERE_AM_I_CHANGED, onPropertyUpdateWhereAmIStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_SIMULATION_MODE_CHANGED, onPropertyUpdateSimulationModeChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateGPSSensorStatusChanged();
      bool onPropertyUpdateWhereAmIStatusChanged();
      void onPropertyUpdateSimulationModeChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(EnableWhereAmIReqMsg)
      ON_COURIER_MESSAGE(DisableWhereAmIReqMsg)
      COURIER_MSG_MAP_END()

      /**
      * Updates the WhereAMIInfo upon activation
      */
      bool onCourierMessage(const EnableWhereAmIReqMsg& oMsg);
      /**
      * Stops Updating the WhereAmIInfo
      */
      bool onCourierMessage(const DisableWhereAmIReqMsg& oMsg);

   private:
      void updateCursorHairDirectionWithCarPositionInfo();
      int checkHeadingIndex(int headingIndex);
      void updateArrowHeading(int headingIndex, int offset);
      int getCalibrateHeadingIndex(bool isVehicleCarsor, int headingIndex, int offset);
};


#endif // HALL_TO_MDW_COM
#endif // _HMI_MODEL_POSITION_H
