/**************************************************************************************
* @file         : DetailedRoutePreferenceListHandler.h
* @author       : ECG-Ramesh Kesavan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DETAILED_ROUTE_PREFERENCE_LIST_HANDLER_H
#define DETAILED_ROUTE_PREFERENCE_LIST_HANDLER_H

#include "AppHmi_NavigationStateMachine.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"
#include "Common/DataModel/ListRegistry.h"
#include "NaviSettingsUtil.h"

#ifdef HALL_TO_MDW_COM

class DetailedRoutePreferenceListHandler : public NavMiddlewarePropertyUpdateConsumer, public ListImplementation
{
   public:
      DetailedRoutePreferenceListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~DetailedRoutePreferenceListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from Infostore
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ApplyDetailedRoutePreferenceOptionsReqMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      ON_COURIER_MESSAGE(ChangeUseTrafficInfoReqMsg)
      ON_COURIER_MESSAGE(ChangeUseTollRoadReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      // Courier messages are received from other components (usually View and Controller (StateMachine)).
      virtual bool onCourierMessage(const ApplyDetailedRoutePreferenceOptionsReqMsg& oMsg);
      virtual bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      virtual bool onCourierMessage(const ChangeUseTrafficInfoReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeUseTollRoadReqMsg& oMsg);

   private:
      bool _isDropdownEnabled;
      bool _isCheckboxEnabled[10];
      bool _useTrafficInfo[MAX_SIZE_USE_TRAFFIC_INFO];
      bool _useTollRoad[MAX_SIZE_USE_TRAFFIC_INFO];

      unsigned int _listId;

      Candera::String _currentUseTrafficInfoStr;
      Candera::String _currentUseTollRoadOptionStr;

      enRoadInformationOptions _currentTrafficInformationOption;
      enRoadInformationOptions _currentUseTollRoadOption;

      IsButtonToggleEnabled getMinimizeFerriesStatus();
      IsButtonToggleEnabled getMinimizeTrainTransportStatus();
      IsButtonToggleEnabled getMinimizeSubscriptionRoadStatus();
      IsButtonToggleEnabled getMinimizeUnverifiedRoadStatus();
      IsButtonToggleEnabled getMinimizeUnpavedRoadsStatus();
      IsButtonToggleEnabled getMinimizeHOVLanesStatus();
      IsButtonToggleEnabled getAvoidBorderCrossingStatus();
      IsButtonToggleEnabled getAvoidUTurnStatus();
      IsButtonToggleEnabled getAvoidTunnelStatus();

      Candera::String getUseRealTimeTrafficInfo(navmiddleware::NavMiddleware& navMiddleware);
      Candera::String getUseTollRoadInfo(navmiddleware::NavMiddleware& navMiddleware);
      void setTrafficInformationOption();
      void setUseTollRoadInformation();
      void resetSelectedOption();

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getListDataProviderMainList(::Courier::UInt32);
      tSharedPtrDataProvider configureDropdownList(::Courier::UInt32);
      inline void getCurrentValues();
      FEATSTD_MAKE_CLASS_UNCOPYABLE(DetailedRoutePreferenceListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // DETAILED_ROUTE_PREFERENCE_LIST_HANDLER_H
