/**************************************************************************************
* @file         : RouteDataUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_ROUTE_DATA_UTILS_H)
#define _ROUTE_DATA_UTILS_H

#include "Common/Util/HMIModelIncludes.h"
#include "CgiExtensions/ImageLoader.h"

extern bool VEHICLE_PROFILE_CHANGED;
enum TurnListSpecificIcon
{
   TURNLIST__ICON_FERRY,
   TURNLIST__ICON_AUTOTRAIN,
   TURNLIST__ICON_HIGHWAY_ENTRY,
   TURNLIST__ICON_HIGHWAY_EXIT,
   TURNLIST__ICON_SEASON_RESTRICTED,
   TURNLIST__ICON_TIME_RESTRICTED,
   TURNLIST__ICON_TOLL_ROAD,
   TURNLIST__ICON_MAX
};


void getTurnlistIcon(const navmiddleware::RouteListInfos::RouteListElementInfo& info, ShowRouteListItemData& item, bool isCarMark);
void recalculateRouteGuidance(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore , bool showDestGuidance);
void getSpecificTurnListIconUtil(ShowRouteListItemData& item, int specificIcon);


struct ButtonMoreRouteType
{
   ButtonMoreRouteType() : _alternativeRouteData(NULL), _indexAlternative(0)
   {}

   ButtonMoreRouteType(std::pair<Candera::String*, Courier::DataItemKey> distanceToDestination,
                       std::pair<Candera::String*, Courier::DataItemKey> timeToDestination,
                       std::pair<bool*, Courier::DataItemKey> btnActiveRoute,
                       std::pair<bool*, Courier::DataItemKey> isEnabled,
                       std::pair<bool*, Courier::DataItemKey> isLoading,
                       std::pair<bool*, Courier::DataItemKey> isTouchable,
                       DataBindingItem<AlternativeRouteItemsDataBindingSource>* alternativeRouteData,
                       unsigned int indexAlternative = 0)
      : _distanceToDestination(distanceToDestination)
      , _timeToDestination(timeToDestination)
      , _btnActiveRoute(btnActiveRoute)
      , _isRouteButtonEnabled(isEnabled)
      , _isRouteDataLoading(isLoading)
      , _isRouteButtonTouchable(isTouchable)
      , _alternativeRouteData(alternativeRouteData)
      , _indexAlternative(indexAlternative)
   {}

   std::pair<Candera::String*, Courier::DataItemKey> _distanceToDestination;
   std::pair<Candera::String*, Courier::DataItemKey> _timeToDestination;
   std::pair<bool*, Courier::DataItemKey> _btnActiveRoute;
   std::pair<bool*, Courier::DataItemKey> _isRouteButtonEnabled;
   std::pair<bool*, Courier::DataItemKey> _isRouteDataLoading;
   std::pair<bool*, Courier::DataItemKey> _isRouteButtonTouchable;
   DataBindingItem<AlternativeRouteItemsDataBindingSource>* _alternativeRouteData;
   unsigned int _indexAlternative;   // Index of multiple route
   std::string _etaToFinalDestination;
   std::string _timeToFinalDestination;

   void setDistanceToDestination(const Candera::String& distance)
   {
      if ((_alternativeRouteData != NULL) && (_distanceToDestination.first != NULL) && (*(_distanceToDestination.first) != distance))
      {
         *(_distanceToDestination.first) = distance;
         _alternativeRouteData->MarkItemModified(_distanceToDestination.second);
      }
   }

   void setTimeToDestination(const Candera::String& timeToDest)
   {
      if ((_alternativeRouteData != NULL) && (_timeToDestination.first != NULL) && (*(_timeToDestination.first) != timeToDest))
      {
         *(_timeToDestination.first) = timeToDest;
         _alternativeRouteData->MarkItemModified(_timeToDestination.second);
      }
   }

   void setActiveRouteOption(bool activeRoute)
   {
      if ((_alternativeRouteData != NULL) && (_btnActiveRoute.first != NULL) && (*(_btnActiveRoute.first) != activeRoute))
      {
         *(_btnActiveRoute.first) = activeRoute;
         _alternativeRouteData->MarkItemModified(_btnActiveRoute.second);
      }
   }

   bool getActiveRouteOption()
   {
      if (_btnActiveRoute.first != NULL)
      {
         return *(_btnActiveRoute.first);
      }
      return false;
   }

   void setRouteOptionLoadingState(bool isLoading)
   {
      if (_alternativeRouteData != NULL)
      {
         if( (_isRouteDataLoading.first != NULL) && (*(_isRouteDataLoading.first) != isLoading))
         {
            *(_isRouteDataLoading.first) = isLoading;
            _alternativeRouteData->MarkItemModified(_isRouteDataLoading.second);
         }
         if( (_isRouteButtonTouchable.first != NULL) && (*(_isRouteButtonTouchable.first) != (!isLoading) ))
         {
            *(_isRouteButtonTouchable.first) = (!isLoading);
            _alternativeRouteData->MarkItemModified(_isRouteButtonTouchable.second);
         }
      }
   }

   void setRouteOptionButtonState(bool isEnabled)
   {
      if ((_alternativeRouteData != NULL) && (_isRouteButtonEnabled.first != NULL) && (*(_isRouteButtonEnabled.first) != isEnabled))
      {
         *(_isRouteButtonEnabled.first) = isEnabled;
         _alternativeRouteData->MarkItemModified(_isRouteButtonEnabled.second);
      }
   }

   bool getRouteOptionButtonState()
   {
      if (_isRouteButtonEnabled.first != NULL)
      {
         return *(_isRouteButtonEnabled.first);
      }
      return false;
   }

   void reset()
   {
      _indexAlternative = 0;
      _etaToFinalDestination = "";
      _timeToFinalDestination = "";
   }
};

#endif // _ROUTE_DATA_UTILS_H
