/**************************************************************************************
* @file         : UserPOIListHandler.h
* @author       : ECH-Venkata Sairam Dubba
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2020 Robert Bosch GmbH
*                 (C) 2020 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_USER_POI_LIST_HANDLER_H)
#define _USER_POI_LIST_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"   // Includes other data model related header files
#include "ListRegistry.h"                   // Defines class ListImplementation
#include "Destination/SpellerHandler.h"     // For use of free text speller

using namespace navmiddleware;

class UserPOIListHandler : public HMIModelBase, public ListImplementation
{
   public:

      UserPOIListHandler(NavMiddleware& navMiddleware, InfoStore& infoStore);
      ~UserPOIListHandler();

      void initialize();
      void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_INPUT_INFO_CHANGED, onPropertyUpdateUPOIInputInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_ENTRIES_CHANGED, onPropertyUpdateUPOIEntriesChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_FREE_TEXT_SEARCH_RESULTS_CHANGED, onPropertyUpdateUPOIEntriesChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateUPOIInputInfoChanged();
      void onPropertyUpdateUPOIEntriesChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(UPOIResetCoordinatesReqMsg)
      ON_COURIER_MESSAGE(UPOIStartInputReqMsg)
      ON_COURIER_MESSAGE(UPOIBrowseBackReqMsg)
      ON_COURIER_MESSAGE(UPOILeaveInputReqMsg)
      ON_COURIER_MESSAGE(SpellerOKBtnPressedMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const UPOIResetCoordinatesReqMsg& oMsg);
      bool onCourierMessage(const UPOIStartInputReqMsg& oMsg);
      bool onCourierMessage(const UPOIBrowseBackReqMsg& oMsg);
      bool onCourierMessage(const UPOILeaveInputReqMsg& oMsg);
      bool onCourierMessage(const SpellerOKBtnPressedMsg& oMsg);

   private:
      bool _isListRequested;
      bool _isListAvailable;
      bool _isFreeTextSearch;
      unsigned int _listId;
      unsigned int _startIndexListRequest;
      unsigned int _windowElementSize;
      unsigned int _startIndexVisibleArea;

      DataBindingItem<POITitleDataBindingSource> _poiTitleInfoData;
      tSharedPtrDataProvider getListDataProvider();

      void updateList();
      void updateUPOIsInMap();
      void showDefaultUPOIMapView();
      inline void fetchLocationInfo(LocationInfos& locationInfos);
      std::string getUPOIDescription(const navmiddleware::LocationAttributeInfos& infos);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(UserPOIListHandler);
};


#endif // USER_POI_LIST_HANDLER_H
