/* ***************************************************************************************
* FILE:          POIListHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  POIListHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_POI_LIST_HANDLER_H)
#define _POI_LIST_HANDLER_H


#include "Common/Util/HMIModelIncludes.h" 	    // Includes other data model related header files
#include "AppHmi_NavigationStateMachineData.h"	 // SM external variable EXT_bIsPOIFts defined here
#include "ListRegistry.h"						       // Defines class ListImplementation
#include "Destination/SpellerHandler.h"		    // For use of free text speller

const Candera::UInt8 MAX_POI_LEVEL = 5;    		 // 4 levels in POI category list + POI address list

using namespace navmiddleware;

class POIListHandler : public HMIModelBase, public ListImplementation
{
   public:

      POIListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~POIListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_INPUT_INFO_CHANGED, onPropertyUpdatePOIInputInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_ENTRIES_CHANGED, onPropertyUpdatePOIEntriesChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_FREE_TEXT_SEARCH_RESULTS_CHANGED, onPropertyUpdateFtsResultsChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdatePOIInputInfoChanged();
      void onPropertyUpdatePOIEntriesChanged();
      void onPropertyUpdateFtsResultsChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // register for list widget messages
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE(InitPOICategoryBrowseReqMsg)
      ON_COURIER_MESSAGE(POICategoryBrowseBackReqMsg)
      ON_COURIER_MESSAGE(ShowAllPOICategoryReqMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(SpellerOKBtnPressedMsg)
      ON_COURIER_MESSAGE(POIStartFtsReqMsg)
      ON_COURIER_MESSAGE(POILeaveFtsReqMsg)
      ON_COURIER_MESSAGE(POILeaveInputReqMsg)
      ON_COURIER_MESSAGE(ResetCoordinatesReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      virtual bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      bool onCourierMessage(const InitPOICategoryBrowseReqMsg& oMsg);
      bool onCourierMessage(const POICategoryBrowseBackReqMsg& oMsg);
      bool onCourierMessage(const ShowAllPOICategoryReqMsg& oMsg);
      bool onCourierMessage(const SpellerOKBtnPressedMsg& oMsg);
      bool onCourierMessage(const POIStartFtsReqMsg& oMsg);
      bool onCourierMessage(const POILeaveFtsReqMsg& oMsg);
      bool onCourierMessage(const POILeaveInputReqMsg& oMsg);
      bool onCourierMessage(const ResetCoordinatesReqMsg& oMsg);

   private:
      tSharedPtrDataProvider getListDataProvider(unsigned int listID, const char* itemID, unsigned int startIndex, unsigned int windowElementSize);
      void updateList();
      void updatePOIsInMap();
      void showDefaultPOIMapView();
      void updatePOITitle(Candera::String poiTitleValue, bool isPOICategoryBrowseBack);
      inline void fetchLocationInfo(LocationInfos& locationInfos);

      unsigned int _listId;
      unsigned int _poiLevel;
      unsigned int _startIndexListRequest;
      unsigned int _windowElementSize;
      unsigned int _numCategoryEntriesFTS;
      bool _isCategoryEntryUpdatedFTS;
      bool _poiListReady;   // Used only for Hierarchical POI search and not FTS
      bool _isListRequested;
      bool _isPOICategoryBrowseBack;
      unsigned int _startIndexVisibleArea;
      Candera::String _poiTitleValue[MAX_POI_LEVEL];
      navmiddleware::LocationSearchScope::Type _enSearchScope;

      /** Binding source to distinguish between Topcategory and ResultedPOIlist */
      DataBindingItem<POICategoryBrowseCheckDataBindingSource> _isPOICategoryBrowse;
      DataBindingItem<POITitleDataBindingSource> _poiTitleInfoData;
      DataBindingItem<POITopCategoryTitleDataBindingSource> _poiTopLevelTitleInfoData;
      DataBindingItem<POIDetailedInfoDataBindingSource> _isPOIDetailedInfoData;
      DataBindingItem<AddressEntryTitleTextDataBindingSource>_FtsTitleData;	// Title for FTS speller scene

   protected:
      using ListImplementation::onCourierMessage;
      navmiddleware::NavMiddleware _navMiddleware;
};


#endif
