/**************************************************************************************
* @file         : NavDataUpdateUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAVDATA_UPDATE_UTILS_H
#define NAVDATA_UPDATE_UTILS_H

#include "NavMiddleware.h"
#include "Common/Util/HMIModelIncludes.h"

#define NAVDATA_DEVICEID__UNKNOWN 255
#define NAVDATA_INIT_DEVICEID() unsigned int deviceId = NAVDATA_DEVICEID__UNKNOWN

#define IS_DEVICE_ACTIVE(DEVICETYPE) (isDeviceActive(_navMiddleware.getNavDataDeviceInfos(), navmiddleware::DEVICETYPE, deviceId))
#define IS_DEVICE_AVAILABLE(DEVICETYPE) (isDeviceAvailable(_navMiddleware.getNavDataDeviceInfos(), navmiddleware::DEVICETYPE, deviceId))
#define IS_DEVICE_CONTAINS_INC_UPDATE(DEVICETYPE) (isDeviceContainsIncUpdate(_navMiddleware.getNavDataDeviceInfos(), navmiddleware::DEVICETYPE, deviceId))
#define IS_DEVICE_CONTAINS_FULL_UPDATE(DEVICETYPE) (isDeviceContainsFullUpdate(_navMiddleware.getNavDataDeviceInfos(), navmiddleware::DEVICETYPE, deviceId))

/**
 * @param:  NavDataDeviceInfos = _navMiddleware.getNavDataDeviceInfos()
 *          NavDataDeviceInfo::DeviceType
 *          deviceId: return deviceId
 * @return: unsigned int& deviceId: deviceId of connected device
 *          bool: if device AVAILABLE/INC_UPDATE/FULL_UPDATE
 */

bool isDeviceActive(const navmiddleware::NavDataDeviceInfos& deviceInfo, navmiddleware::DeviceType deviceType, unsigned int& deviceId);
bool isDeviceAvailable(const navmiddleware::NavDataDeviceInfos& deviceInfo, navmiddleware::DeviceType deviceType, unsigned int& deviceId);
bool isDeviceContainsIncUpdate(const navmiddleware::NavDataDeviceInfos& deviceInfo, navmiddleware::DeviceType deviceType, unsigned int& deviceId);
bool isDeviceContainsFullUpdate(const navmiddleware::NavDataDeviceInfos& deviceInfo, navmiddleware::DeviceType deviceType, unsigned int& deviceId);

unsigned int getDeviceStatus(const navmiddleware::NavDataDeviceInfos& deviceInfo, navmiddleware::DeviceType deviceType, unsigned int& deviceId);

::std::string getDataUpdateStatusAsString(navmiddleware::NavDataUpdateStatus::DataUpdateStatus navDataUpdateStatus);
::std::string getAvailableUpdatesRequestTypeAsString(navmiddleware::AvailableUpdatesRequestType requestType);

enNavDataUpdate__UpdateStatus getMappedUpdateStatus(navmiddleware::NavDataUpdateStatus::DataUpdateStatus status);
enNavDataUpdate__DeviceStatus getMappedDeviceStatus(navmiddleware::DeviceStatus status);
//enNavDataUpdate__ExportStatus getMappedExportStatus(navmiddleware::NavDataUpdateUSBDeviceStatus status);

Candera::String constructUpdateTime(unsigned int timeInSeconds);
Candera::String constructDataSize(uint64_t dataSizeInBytes);
Candera::String constructOverviewInfo(const navmiddleware::NavDataUpdateOverviewInfo& navDataUpdateOverviewInfo);

#endif // NAVDATA_UPDATE_UTILS_H
