/**************************************************************************************
* @file         : MapUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_UTILS_H
#define MAP_UTILS_H 1

#include "Common/Util/HMIModelDefines.h"
#include "Common/Util/HMIModelBase.h"

#ifdef HALL_TO_MDW_COM

bool isMultiViewActive(navmiddleware::NavMiddleware& navMiddleware);
bool isJunctionViewActive(navmiddleware::NavMiddleware& navMiddleware);
bool isIntersectionMapActive(navmiddleware::NavMiddleware& navMiddleware);
bool isAdditionalInfosActive(navmiddleware::NavMiddleware& navMiddleware);
bool isAutoShowTurnListOnFreewayActive(navmiddleware::NavMiddleware& navMiddleware);
bool isJunctionFreeActive(navmiddleware::NavMiddleware& navMiddleware);
uint16_t getDataPixelsForDiscreteMoves(int maxScreenWidth, const navmiddleware::MapCameraModeInfo& mapCameraModeInfo);
void clearLocationsShownInMap(InfoStore& infoStore, navmiddleware::NavMiddleware& navMiddleware);
void highlightLastPickedLocation(navmiddleware::NavMiddleware& navMiddleware, const navmiddleware::PickingResults::PickingResult& pickingResult);
int findDefaultMapScaleFromNominalScales(const std::vector< navmiddleware::NominalScaleInfos::NominalScaleInfo > nominalScaleInfoVector, const int defaultScale);

#define MAP_VIEW_SETTINGS(_changeView_, _viewSetting_, _routeGuidance_) \
   (_changeView_ | _viewSetting_ << 2 | _routeGuidance_ << 4)

#define MAP_HARDKEY_HANDLING(_viewSetting_, _currentView_, _intersectionActive_, _routeGuidance_, _junctionFreeActive_, _autoTurnlistSetting_) \
   (_viewSetting_ | _currentView_ << 2 | _intersectionActive_ << 4 | _routeGuidance_ << 6 | _junctionFreeActive_ << 8 | _autoTurnlistSetting_ << 10)

enum MapMultiViewScreenRouteGuidanceState
{
   MAP_MULTIVIEW_SCREEN_ROUTE_GUIDANCE_OFF = 0,
   MAP_MULTIVIEW_SCREEN_ROUTE_GUIDANCE_ON
};


enum MapMultiViewScreenState
{
   MAP_MULTIVIEW_SCREEN_STATE_FULLSCREEN_STATE = 0,
   MAP_MULTIVIEW_SCREEN_STATE_TURN_LIST_STATE,
   MAP_MULTIVIEW_SCREEN_STATE_DRIVE_REPORT_STATE,
   MAP_MULTIVIEW_SCREEN_STATE_INTERSECTION_STATE,
   MAP_MULTIVIEW_SCREEN_STATE_HIGHWAY_LIST_STATE
};


enum MapMultiViewScreenIntersectionState
{
   MAP_MULTIVIEW_SCREEN_INTERSECTION_INACTIVE = 0,
   MAP_MULTIVIEW_SCREEN_INTERSECTION_ACTIVE
};


enum MapMultiViewScreenJunctionFreeState
{
   MAP_MULTIVIEW_SCREEN_JUNCTION_FREE_INACTIVE = 0,
   MAP_MULTIVIEW_SCREEN_JUNCTION_FREE_ACTIVE
};


enum MapMultiViewScreenAutoTurnListState
{
   MAP_MULTIVIEW_SCREEN_AUTOTURNLIST_INACTIVE = 0,
   MAP_MULTIVIEW_SCREEN_AUTOTURNLIST_ACTIVE
};


#endif // HALL_TO_MDW_COM
#endif // MAP_UTILS_H
