/**************************************************************************************
* @file         : MapInteractionHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MAP_INTERACTION_HANDLER_H
#define MAP_INTERACTION_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"

#ifdef HALL_TO_MDW_COM

/**
* Handler for map interaction. It e.g. decides if map is touchable in different camera modes or handles map in speed lock mode
*/
class MapInteractionHandler : public HMIModelBase
{
   public:
      MapInteractionHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~MapInteractionHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_TOUCH_EVENT, onPropertyUpdateMapTouchEvent)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_NOMINAL_SCALES_CHANGED, onPropertyUpdateMapNominalScalesChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE, handleMapCameraAndViewMode)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateMapTouchEvent();
      void onPropertyUpdateMapNominalScalesChanged();
      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      COURIER_MSG_MAP_BEGIN(0)
      COURIER_MSG_MAP_END()
      void handleMapCameraAndViewMode();

   private:
      void setConfigureTouch(navmiddleware::MapViewId mapViewId, bool moveAllowed, bool zoomAllowed, bool rotateAllowed, bool pitchAllowed, bool touchGestureTapAllowed, bool touchGestureswipeAllowed, bool touchGestureRotateAllowed, bool touchGesturePinchAllowed, bool scrollOnHold, int minScale, int maxScale);

      void handleTouchGestureTapped();
      void handleTouchGestureSwipeInSpeedLockMode();
      void handleTouchGestureRotateInSpeedLockMode();
      void handleTouchGesturePinchInSpeedLockMode();

      void activateMapScrollScreenIfNeeded();
      navmiddleware::ScrollDirection getScrollDirectionFromSwipeAngle();
      navmiddleware::ScrollDirection getScrollDirectionFromLongTap();

      enMapCameraAndViewModeMode _lastRequestedMapCameraAndViewMode;
      int _maxNominalMapScale;
      int _minNominalMapScale;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(MapInteractionHandler);
};


#endif // HALL_TO_MDW_COM
#endif // MAP_INTERACTION_HANDLER_H
