/**************************************************************************************
* @file         : HMIModelMap.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_MAP_H
#define HMI_MODEL_MAP_H

#include "Common/Util/HMIModelIncludes.h"
#include "MapCameraAndViewHandler.h"
#include "MapInteractionHandler.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "App/Core/VehicleDataClient/VehicleDataClientHandler.h"

#ifdef HALL_TO_MDW_COM

/**
* HMI sub model component for map
*/
class HMIModelMap : public HMIModelBase
   , public IETACalculationParams
{
   public:
      HMIModelMap(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelMap();

      virtual void initialize();
      virtual void deinitialize();
      virtual void sendCANDataToCalculateETACabinOnly(const uint16 timeToReachDest, const uint8 tmMode, const uint64 timeDate);

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_CAMERAMODE_CHANGED, onPropertyUpdateMapCameraModeChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_INFO_CHANGED, onPropertyUpdatePositionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_CAMERAINFOS_CHANGED, onPropertyUpdateMapCameraInfosChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_ARRIVALINFOS_CHANGED, onPropertyUpdateArrivalInfosChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERINFOS_CHANGED, onPropertyUpdateManeuverInfosChanged)
#ifdef ENABLE_FEATURE_SPEED_LIMIT
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_SPEEDLIMIT_CHANGED, onPropertyUpdateSpeedLimitStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_OVERSPEED_CHANGED, onPropertyUpdateOverSpeedStatusChanged)
#endif
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_VIDEO_STREAM_STATUS_CHANGED, onPropertyUpdateMapVideoStreamStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERVIEW_CHANGED, onPropertyUpdateManeuverViewChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_ESTIMATED_TIME_MODE_CHANGED, onPropertyUpdateEstimatedTimeModeChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HMI_APP_STATE_CHANGED, onPropertyUpdateHmiAppStateChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_MAP_STREAMING_STATUS_CHANGED, onPropertyUpdateMapStreamStateChanged)
      ON_PROPERTY_INFOSTORE_UPDATE(NAVI_HARD_RESTRICTION_STATUS_CHANGED, onPropertyUpdateHardRestrictionStatusChanged)
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE_NOTRACE(UnfreezeMapReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(FreezeMapReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(FreezeAndHideMapReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(SetMapCameraModeReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(OverSpeedTimerExpiredReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ZoomInReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ZoomOutReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ButtonReactionMsg)
      ON_COURIER_MESSAGE_NOTRACE(TimerWidgetExpiryMsg)
      ON_COURIER_MESSAGE_NOTRACE(ReCenterMapScrollReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(StartStopMapStreamReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(SetMapLayerVisibilityReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ETAAvailableUpdateMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_REF(_mapCameraAndViewHandler)
      COURIER_MSG_MAP_DELEGATE_END()

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const UnfreezeMapReqMsg& oMsg);
      bool onCourierMessage(const FreezeMapReqMsg& oMsg);
      bool onCourierMessage(const FreezeAndHideMapReqMsg& oMsg);
      bool onCourierMessage(const SetMapCameraModeReqMsg& oMsg);
      bool onCourierMessage(const OverSpeedTimerExpiredReqMsg& oMsg);
      bool onCourierMessage(const ZoomInReqMsg& oMsg);
      bool onCourierMessage(const ZoomOutReqMsg& oMsg);
      bool onCourierMessage(const TimerWidgetExpiryMsg& oMsg);
      bool onCourierMessage(const ReCenterMapScrollReqMsg& oMsg);
      bool onCourierMessage(const StartStopMapStreamReqMsg& oMsg);
      bool onCourierMessage(const SetMapLayerVisibilityReqMsg& oMsg);
      bool onCourierMessage(const ETAAvailableUpdateMsg& oMsg);
      bool onPropertyUpdateEstimatedTimeModeChanged() const;
      bool onPropertyUpdateHardRestrictionStatusChanged();
      bool onPropertyUpdatePositionInfoChanged();
      bool onPropertyUpdateMapCameraModeChanged();
      bool onPropertyUpdateMapCameraInfosChanged() const;
      void onPropertyUpdateArrivalInfosChanged() const;
      bool onPropertyUpdateManeuverInfosChanged() const;
      bool onPropertyUpdateSpeedLimitStatusChanged();
      bool onPropertyUpdateOverSpeedStatusChanged();
      bool onPropertyUpdateHmiAppStateChanged();
      bool onPropertyUpdateGuidanceSettingsChanged();
      void onPropertyUpdateGuidanceStateChanged();
      void onPropertyUpdateMapVideoStreamStatusChanged();
      void onPropertyUpdateManeuverViewChanged();
      bool onPropertyUpdateMapStreamStateChanged();
      void setMapCameraViewMode(enMapCameraAndViewModeMode mapCameraViewMode);

   private:

      bool _isMapActive;
      bool _wasMapActiveWhenGoingToBackground;
      bool _isMapViewUpdateNeeded;
      bool _isHardRestrictionPresent;
      uint16 _timeToReachDest;
      uint8 _tmMode;
      uint64 _timeDate;

      Util::Timer _timer;

      MapCameraAndViewHandler _mapCameraAndViewHandler;
      MapInteractionHandler _mapInteractionHandler;
      navmiddleware::settings::MapView _currentMapView;
      navmiddleware::settings::MapHMISplitMode _currentMapHMISplitMode;
      DataBindingItem<ZoomBarInfoDataBindingSource> _zoomBarInfo;
      DataBindingItem<MultiLinePopuptextDataBindingSource> _multiLinePopuptext;

      void freezeMap();
      void unfreezeMap();
      void freezeAndHideMap();
      void startStopMapStreamRequest(const REGION& regionId, const bool& status);
      void switchTo2DMapOnStreaming();
      void restoreLastMapViewAfterStreaming();
      void applyMapSettingsOnStreaming();
      void computeGuidanceRuntime(bool guidanceStatus);
      void computeMapStreamingRuntime(bool streamStatus);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelMap);
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_MAP_H
