/**************************************************************************************
* @file         : HMIModelComponent.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_COMPONENT_H
#define HMI_MODEL_COMPONENT_H

#include "Common/Util/HMIModelDefines.h"
#include "Common/Util/NavMiddlewareUtils.h"
#include "Common/Util/NavMiddlewareStartup.h"
#include "Common/Service/HMIModelNavigationDataUpdateService.h"
#include "Destination/DestinationAddressInputHandler.h"
#include "Destination/DestinationMatchListHandler.h"
#include "Destination/DestinationLatLongSpellerHandler.h"
#include "Destination/SpellerHandler.h"
#include "Map/HMIModelMap.h"
#include "Destination/MapPickingHandler.h"
#include "POI/POIListHandler.h"
#include "POI/UserPOIListHandler.h"
#include "Destination/PreviousDestinationListHandler.h"
#include "Settings/HMIModelSettings.h"
#include "AddressDetailedInfo/AddressDetailedInfo.h"
#include "Favorites/FavoritesListHandler.h"
#include "TMC/TrafficListHandler.h"
#include "Route/RouteListHandler.h"
#include "Settings/HMIModelPosition.h"
#include "Route/CalculateRouteHandler.h"
#include "Route/WaypointListHandler.h"
#include "POI/StackedPOIOnMapListHandler.h"
#include "Guidance/HMIModelGuidance.h"
#include "Route/MapPickingOptionHandler.h"
#include "NavDataUpdate/HMIModelNavDataUpdate.h"
#include "NavDataUpdate/HMIModelNavDataUpdate.h"
#include "TestMode/EngineeringMenuHandler.h"
#include "Common/Service/HMIModelNavigationService.h"
#include "Common/Service/HMIModelNavigationSDSService.h"

#ifdef HALL_TO_MDW_COM

/**
* Main hmi model component
*/
class HMIModelComponent : public navmiddleware::PropertyUpdateCallback
{
   public:
      HMIModelComponent();
      virtual ~HMIModelComponent();

      bool initialize();
      void savePersistency();
      bool deinitialize();
      bool reinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_STARTED, onPropertyUpdateNavMiddlewareStarted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_STOPPED, onPropertyUpdateNavMiddlewareStopped)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_NAVDATAUPDATE_STARTED, onPropertyUpdateNavDataUpdateStarted)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_NAVDATAUPDATE_FINISHED, onPropertyUpdateNavDataUpdateFinished)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LIFECYCLE_NAVDATA_RECOVERY, onPropertyUpdateNavDataRecovery)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateNavMiddlewareStarted();
      bool onPropertyUpdateNavMiddlewareStopped();
      bool onPropertyUpdateNavDataUpdateStarted();
      bool onPropertyUpdateNavDataUpdateFinished();
      void onPropertyUpdateNavDataRecovery();

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(Courier::ShutdownMsg)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(DeactivateLimitedModeReqMsg)
      ON_COURIER_MESSAGE(SetBackButtonLevelReqMsg)
      ON_COURIER_MESSAGE(HKStateUpdMsg)
      ON_COURIER_MESSAGE(ValidateNaviEntryConditionReqMsg)
      COURIER_MSG_MAP_DELEGATE_START_AND_LOCK(_navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK((*_destinationAddressInputHandler), _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_destinationLatLongSpellerHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_userpoiListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_poiListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_favoritesListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_trafficListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_waypointListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_routeListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK((*_spellerHandler), _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_destinationMatchListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_previousDestinationListHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_addressDetailedInfo, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_stackedPOIOnMapListHandler, _navMiddleware)

      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelMap, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_mapPickingHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_infoStore, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelSettings, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelPosition, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_calculateRouteHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelGuidance, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_mapPickingOptionHandler, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelNavDataUpdate, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelNavigationService, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelNavigationSDSService, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_hmiModelNavigationDataUpdateService, _navMiddleware)
      COURIER_MSG_DELEGATE_TO_REF_AND_UNLOCK(_engineeringmenuhandler, _navMiddleware)
      COURIER_MSG_MAP_DELEGATE_END_AND_UNLOCK(_navMiddleware)

      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      bool onCourierMessage(const Courier::ShutdownMsg& oMsg);
      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
      bool onCourierMessage(const DeactivateLimitedModeReqMsg& oMsg);
      bool onCourierMessage(const SetBackButtonLevelReqMsg& oMsg);
      bool onCourierMessage(const HKStateUpdMsg& oMsg);
      bool onCourierMessage(const ValidateNaviEntryConditionReqMsg& oMsg);
   private:
      HMIModelComponent(const HMIModelComponent& rhs);
      HMIModelComponent& operator= (const HMIModelComponent& rhs);

      // Model sub models
      DestinationAddressInputHandler* _destinationAddressInputHandler;
      DestinationMatchListHandler    _destinationMatchListHandler;
      DestinationLatLongSpellerHandler    _destinationLatLongSpellerHandler;
      SpellerHandler*                 _spellerHandler;
      HMIModelMap                    _hmiModelMap;
      UserPOIListHandler             _userpoiListHandler;
      POIListHandler                 _poiListHandler;
      MapPickingHandler              _mapPickingHandler;
      PreviousDestinationListHandler   _previousDestinationListHandler;
      HMIModelSettings                 _hmiModelSettings;
      FavoritesListHandler           _favoritesListHandler;
      TrafficListHandler           _trafficListHandler;
      WaypointListHandler           _waypointListHandler;
      RouteListHandler              _routeListHandler;
      AddressDetailedInfo            _addressDetailedInfo;
      HMIModelPosition                 _hmiModelPosition;
      CalculateRouteHandler           _calculateRouteHandler;
      StackedPOIOnMapListHandler      _stackedPOIOnMapListHandler;
      HMIModelGuidance                _hmiModelGuidance;
      MapPickingOptionHandler            _mapPickingOptionHandler;
      HMIModelNavDataUpdate               _hmiModelNavDataUpdate;
      HMIModelNavigationService       _hmiModelNavigationService;
      HMIModelNavigationSDSService    _hmiModelNavigationSDSService;
      HMIModelNavigationDataUpdateService _hmiModelNavigationDataUpdateService;
      EngineeringMenuHandler              _engineeringmenuhandler;
      /** list of sub models for generic handling */
      std::vector<HMIModelBase*> _hmiSubModels;

      /** NavMiddleware instance */
      navmiddleware::NavMiddleware _navMiddleware;

      /** global info store container instance */
      InfoStore _infoStore;

      /** Databinding navigation middleware status */
      DataBindingItem<NaviBackButtonLevelDataBindingSource> _navBackButtonLevel;
      bool _isNavAppInForeground;
      bool _isRestartRGNeeded;
      bool _isReinitialized;
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_COMPONENT_H
