/**************************************************************************************
* @file         : ManeuverViewHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_MANEUVER_VIEW_HANDLER)
#define _MANEUVER_VIEW_HANDLER

#include "Common/Util/HMIModelIncludes.h"
#include "Map/MapUtils.h"
//#include <map>
#if defined(HALL_TO_MDW_COM)

class ManeuverViewHandler : public HMIModelBase
{
   public:
      ManeuverViewHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~ManeuverViewHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_MANEUVERVIEW_CHANGED, onPropertyUpdateManeuverViewChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_VIDEO_STREAM_STATUS_CHANGED, onPropertyUpdateMapVideoStreamStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::MAP_SET_MAP_CAMERA_AND_VIEW_MODES_DONE, onPropertyUpdateMapCameraViewModeChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      void onPropertyUpdateManeuverViewChanged();
      void onPropertyUpdateMapVideoStreamStatusChanged();

      bool onPropertyUpdateMapCameraViewModeChanged();

      void updateMainMapScreenStateDataOnApplicationStateChangedToForeground();

   private:
      // Methods checks if the junction is currently shown on the screen
      void processJunctionView();
      void setJunctionMapMode(bool isJunctionView);
      bool isJunctionViewVisible();

      /** Send request to MapCameraAndViewHandler to reevaluate the current situation */
      void sendMapCameraAndViewRequest();

      /** Update the junction view in junctionViewImageData */
      bool updateJunctionViewImage();

      /** Send junctionViewImageData to GUI */
      bool sendJunctionViewImageData();

      void setIntersectionMapMode(bool isIntersectionView);

      DataBindingItem<HlgImageDataDataBindingSource> _junctionViewImageData; // @Todo: Rename data binding HlgImageDataDataBindingSource to JunctionViewImageDataDataBindingSource
      DataBindingItem<MapMainScreenStateDataBindingSource> _mapMainScreenStateData;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(ManeuverViewHandler);
};


#endif // HALL_TO_MDW_COM
#endif // _MANEUVER_VIEW_HANDLER
