/**************************************************************************************
* @file         : HMIModelGuidance.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_HMI_MODEL_GUIDANCE_H)
#define _HMI_MODEL_GUIDANCE_H

#include "Common/Util/HMIModelIncludes.h"
#include "Guidance/LaneGuidanceHandler.h"
#include "Guidance/SignpostDisplayHandler.h"
#include "Guidance/ManeuverViewHandler.h"

#if defined(HALL_TO_MDW_COM)
/**
* HMI sub model component for guidance
*/
class HMIModelGuidance : public HMIModelBase
{
   public:
      HMIModelGuidance(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelGuidance();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::GUIDANCE_STATE_CHANGED, onPropertyUpdateGuidanceStateChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_ARRIVALINFOS_CHANGED, onPropertyUpdateArrivalInfosChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      bool onPropertyUpdateGuidanceStateChanged();
      bool onPropertyUpdateArrivalInfosChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_REF(_laneGuidanceHandler)
      COURIER_MSG_MAP_DELEGATE_END()

   private:
      LaneGuidanceHandler _laneGuidanceHandler;
      SignpostDisplayHandler _signpostDisplayHandler;
      ManeuverViewHandler  _maneuverViewHandler;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelGuidance);
};


#endif // HALL_TO_MDW_COM
#endif // _HMI_MODEL_GUIDANCE_H
