/**************************************************************************************
* @file         : HMIModelGuidance.cpp
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "HMIModelGuidance.h"
//#include "Common/Util/PopupUtils.h"
#include "Route/RouteDataUtils.h"
#include "Map/MapScreenDataUtils.h"
#include "Settings/NaviSettingsUtil.h"
#include "Settings/VehicleSettingsMetaData.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/HMIModelGuidance.cpp.trc.h"
#endif

#if defined (HALL_TO_MDW_COM)

using namespace navmiddleware;

HMIModelGuidance::HMIModelGuidance(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore)
   : HMIModelBase(navMiddleware, infoStore)
   , _laneGuidanceHandler(navMiddleware, infoStore)
   , _signpostDisplayHandler(navMiddleware, infoStore)
   , _maneuverViewHandler(navMiddleware, infoStore)
{
}


HMIModelGuidance::~HMIModelGuidance()
{
}


void HMIModelGuidance::initialize()
{
   _navMiddleware.registerGuidancePropertyUpdateCallback(*this);
   _navMiddleware.registerRoutePropertyUpdateCallback(*this);

   _laneGuidanceHandler.initialize();
   _signpostDisplayHandler.initialize();
   _maneuverViewHandler.initialize();
}


void HMIModelGuidance::deinitialize()
{
   _navMiddleware.unregisterGuidancePropertyUpdateCallback(*this);
   _navMiddleware.unregisterRoutePropertyUpdateCallback(*this);
   _signpostDisplayHandler.deinitialize();
   _maneuverViewHandler.deinitialize();
}


bool HMIModelGuidance::onPropertyUpdateGuidanceStateChanged()
{
   const bool guidanceActive = _navMiddleware.isGuidanceActive();
   ETG_TRACE_USR1(("HMIModelGuidance::onPropertyUpdateGuidanceStateChanged(%d)", guidanceActive));

   _infoStore.setIsGuidanceActive(guidanceActive);

   // Navi homescreen gadget and map overlay state are updated based on EXT_bIsGuidanceActive,
   // so that guidance info is not shown after vehicle reaches destination while in demo mode.
   (EXT_bIsGuidanceActive) ? setNavigationGadgetStatus(NAVI_GADGET_STATUS__ACTIVE_GUIDANCE, true, _infoStore.getVehicleProfile()) : setNavigationGadgetStatus(NAVI_GADGET_STATUS__NO_GUIDANCE, true, _infoStore.getVehicleProfile());

   // map overlay
   if (true == _infoStore.isSecondaryMapStreamingActive())
   {
      bool textureStatus = (true == EXT_bIsGuidanceActive) ? TEXTURE_ACTIVE : TEXTURE_INACTIVE;
      POST_MSG((COURIER_MESSAGE_NEW(::hmibase::gadget::ActivateImageProviderReqMsg)(MAP_OVERLAY, textureStatus)));
   }
   return true;
}


bool HMIModelGuidance::onPropertyUpdateArrivalInfosChanged()
{
   ETG_TRACE_USR4(("HMIModelGuidance::onPropertyUpdateArrivalInfosChanged()"));

   bool guidanceActive = _navMiddleware.isGuidanceActive();
   // We do not want to resume guidance if isApproachingCurrentDest is true (within 500 meters of destination)
   if (guidanceActive && (_navMiddleware.getArrivalInfos().isApproachingCurrentDest() == false))
   {
      _infoStore.setIsGuidanceActive(true);
   }
   else
   {
      _infoStore.setIsGuidanceActive(false);
   }
   return true;
}


#endif // HALL_TO_MDW_COM
