/* ***************************************************************************************
* FILE:          FavoritesListHandler.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  FavoritesListHandler.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined(_FAVORITES_LIST_HANDLER_H)
#define _FAVORITES_LIST_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "ListRegistry.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "NavMiddleware.h"
#include "../Common/Util/HMIModelDefines.h"
#include "../Common/Util/NavMiddlewareUtils.h"
#include "../Common/Util/StaticListHandlerBase.h"
#include "../Common/Util/HMIModelIncludes.h"
#include "../Destination/SpellerHandler.h"


class FavoritesListHandler : public HMIModelBase, public ListImplementation
{
   public:

      FavoritesListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~FavoritesListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_STORE_ENTRY_STATUS_CHANGED, onPropertyUpdateDestinationMemoryStoreEntryStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_HOME_LIST_CHANGED, onPropertyUpdateDestinationMemoryHomeListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ADDR_BOOK_LIST_CHANGED, onPropertyUpdateDestinationMemoryAddressBookListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ADDRESSBOOK_STATUS_CHANGED, onPropertyUpdateDestinationMemoryAddressBookStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ENTRY_DETAILS_AVAILABLE, onPropertyUpdateDestinationMemoryEntryDetailsAvailable)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_ADDR_BOOK_ENTRY_REMOVED, onPropertyUpdateDestinationMemoryAddressBookEntryRemoved)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_HOME_ENTRY_REMOVED, onPropertyUpdateDestinationMemoryHomeEntryRemoved)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateDestinationMemoryStoreEntryStatusChanged();
      void onPropertyUpdateDestinationMemoryHomeListChanged();
      void onPropertyUpdateDestinationMemoryAddressBookListChanged();
      void onPropertyUpdateDestinationMemoryAddressBookStatusChanged();
      void onPropertyUpdateDestinationMemoryEntryDetailsAvailable();
      void onPropertyUpdateDestinationMemoryAddressBookEntryRemoved();
      void onPropertyUpdateDestinationMemoryHomeEntryRemoved();
      void ButtonClickOnFavoriteList(unsigned int listIdx);
      void ButtonClickOnReplaceFavoriteList(unsigned int listIdx);
      void ButtonClickOnFavoritesScenes(const Courier::Identifier senderInfo, const Courier::ViewId sceneName);

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ReplaceHomeFavReqMsg)
      ON_COURIER_MESSAGE(FavDeleteReqMsg)
      ON_COURIER_MESSAGE(SpellerOKBtnPressedMsg)
      ON_COURIER_MESSAGE(EnableGuidanceButton_NewAddressReqMsg)
      ON_COURIER_MESSAGE(SetPreviosulyActiveSceneName)
      ON_COURIER_MESSAGE(MaxFavPopupVisibilityReqsMsg)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS();

      virtual bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ReplaceHomeFavReqMsg& oMsg);
      bool onCourierMessage(const FavDeleteReqMsg& oMsg);
      bool onCourierMessage(const SpellerOKBtnPressedMsg& oMsg);
      bool onCourierMessage(const SetPreviosulyActiveSceneName& oMsg);
      bool onCourierMessage(const EnableGuidanceButton_NewAddressReqMsg& oMsg);
      bool onCourierMessage(const MaxFavPopupVisibilityReqsMsg& oMsg);

   private:

      tSharedPtrDataProvider getAddressBookDestinationListDataProvider(unsigned int listId, const char* itemID, unsigned int startIndex, unsigned int windowElementSize) const;
      void addressBookGroupListStartIndexUpdate();
      void removeFavoritesEntry(const navmiddleware::DestinationMemoryEntry::Id& entryId);
      void updateDetailedInfo();

      Candera::String _editNameOKPress;
      bool _isAddressBookModified;
      unsigned int _listID;
      unsigned int _startIndex;
      unsigned int _windowElementSize;
      bool _isAddressHomeClicked;
      bool _isEntryReplace;
      Candera::UInt32 _previousScene;

      DataBindingItem<AddressInputButtonVisibilityDataBindingSource>_addressInputButtonVisibility;
      DataBindingItem<MultiLinePopupTextDataBindingSource> _multiLinePopupText;
};


#endif
