/**************************************************************************************
* @file         : RouteGuidanceHandler.h
* @author       : ECG5- Prieethi Narayanaswamy
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef ROUTE_GUIDANCE_HANDLER_H
#define ROUTE_GUIDANCE_HANDLER_H

#include "List/Data/ListDataProviderDistributor.h"
#include "AppHmi_NavigationStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "Common/Util/HMIModelIncludes.h"

#ifdef HALL_TO_MDW_COM

class RouteGuidanceHandler : public HMIModelBase
{
   public:
      RouteGuidanceHandler(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore);
      virtual ~RouteGuidanceHandler();
      virtual void initialize();
      virtual void deinitialize();

      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_POI_INPUT_INFO_CHANGED, onPropertyUpdatePOIInputInfoChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdatePOIInputInfoChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()
   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(RouteGuidanceHandler);

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
};


#endif // ROUTE_GUIDANCE_HANDLER_H
#endif // ROUTE_GUIDANCE_HANDLER_H
