/**************************************************************************************
* @file         : DestinationAddressInputHandler.cpp
* @author       : ECG5-Prieethi Narayanaswamy
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "string"

#include "util/StrUtf8.h"
#include "AppHmi_NavigationStateMachine.h"
#include "RouteGuidanceHandler.h"
#include "hmi_trace_if.h"
#include "CgiExtensions/ImageLoader.h"
#include "CgiExtensions/CourierMessageMapper.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/RouteGuidanceHandler.cpp.trc.h"
#endif

static const Courier::Identifier  IdClickStopGuidanceBtn = Courier::Identifier("Layer_StopGuidance/ButtonWidget");


#ifdef HALL_TO_MDW_COM

RouteGuidanceHandler::RouteGuidanceHandler(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore)
   : HMIModelBase(_navMiddleware, _infoStore)
{
}


RouteGuidanceHandler::~RouteGuidanceHandler()
{
}


void RouteGuidanceHandler::initialize()
{
   _navMiddleware.registerLocationPropertyUpdateCallback(*this);
}


void RouteGuidanceHandler::deinitialize()
{
   _navMiddleware.unregisterLocationPropertyUpdateCallback(*this);
}


void RouteGuidanceHandler::onPropertyUpdatePOIInputInfoChanged()
{
}


bool RouteGuidanceHandler::onCourierMessage(const ButtonReactionMsg& oMsg)
{
   //const Courier::ViewId ROUTEGUIDANCE_SCENE_NAME = Courier::ViewId("AppHmi_NavigationModule#NavigationScenes#N_Guidance");
   //const Courier::Identifier senderInfo  = oMsg.GetSender();
   //const Courier::ViewId sceneName       = oMsg.GetView();
   //const enReaction  reaction            = oMsg.GetEnReaction();

   //if (sceneName == ROUTEGUIDANCE_SCENE_NAME)
   //{
   //   if ((senderInfo == IdClickStopGuidanceBtn) && (enPress == reaction))
   //   {
   //      _navMiddleware.stopGuidance();
   //   }
   //}
   return false;
}


#endif // HALL_TO_MDW_COM
