/* ***************************************************************************************
* FILE:          POIListHandler.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  POIListHandler.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) -2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
**************************************************************************************** */

#ifndef PREVIOUS_DESTINATION_LIST_HANDLER
#define PREVIOUS_DESTINATION_LIST_HANDLER

#include "../Common/Util/HMIModelIncludes.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "List/Data/ListDataProviderDistributor.h"
#include "ListRegistry.h"
#include "Candera/System/MemoryManagement/SharedPointer.h"
#include "NavMiddleware.h"
#include "../Common/Util/InfoStoreBase.h"


class PreviousDestinationListHandler : public HMIModelBase
{
   public:
      PreviousDestinationListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~PreviousDestinationListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_LAST_DESTINATION_LIST_STATUS_CHANGED, onPropertyUpdateDestinationMemoryLastDestinationListStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::DESTINATIONMEMORY_LAST_DESTINATION_LIST_CHANGED, onPropertyUpdateDestinationMemoryLastDestinationListChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::ROUTE_WAYPOINTINFOS_CHANGED, onPropertyUpdateRouteWaypointInfoChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE_NOTRACE(ListDateProviderReqMsg)
      ON_COURIER_MESSAGE_NOTRACE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(CancelRouteGuidanceReqMsg)
      ON_COURIER_MESSAGE(DeletePreviousDestinationReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const CancelRouteGuidanceReqMsg& oMsg);
      bool onCourierMessage(const DeletePreviousDestinationReqMsg& oMsg);
      void onPropertyUpdateDestinationMemoryLastDestinationListStatusChanged();
      void onPropertyUpdateDestinationMemoryLastDestinationListChanged();
      void onPropertyUpdateRouteWaypointInfoChanged();

      DataBindingItem<PreviousDestCountDataBindingSource>& getPreviousDestCountInfo(void);
      void updatePreviousDestCount(const uint8_t count);
      void Calculatetour();
   private:
      void updatePreviousDestinationsList(unsigned int listId, unsigned int startIndex, unsigned int windowElementSize);
      tSharedPtrDataProvider getPreviousDestinationsListDataProvider(unsigned int listId, const char* itemID, unsigned int startIndex, unsigned int windowElementSize);
      virtual InfoStoreBase::RouteToBeUsedForE2EGuidance getRouteToBeUsedForE2EGuidance() const;
      //std::vector <navmiddleware::ExternalLocation> _extLocationVector;
      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowElementSize;
      bool _isDestinationInfoBtnPressed;
      ::std::string m_name;
      navmiddleware::DestinationMemoryItem destinationMemoryItem;
      ::std::vector<navmiddleware::DestinationMemoryItem::IdElement> _lastDestinationElementId;
      DataBindingItem<PlaceInfoDetailsDataBindingSource>_placeInfoDetailsData;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(PreviousDestinationListHandler);
};


#endif // PREVIOUS_DESTINATION_LIST_HANDLER
