/**************************************************************************************
* @file         : DestinationMatchListHandler.h
* @author       : ECG5-Naveen Thangamalayan
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DESTINATION_MATCH_LIST_HANDLER_H
#define DESTINATION_MATCH_LIST_HANDLER_H

#include "Common/Util/HMIModelIncludes.h"   // Includes other data model related header files

#ifdef HALL_TO_MDW_COM

class DestinationMatchListHandler : public HMIModelBase
{
   public:
      DestinationMatchListHandler(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~DestinationMatchListHandler();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADDRESS_ELEMENTS_CHANGED, onPropertyUpdateAddressElementChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateAddressElementChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListDateProviderReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ListDateProviderReqMsg& oMsg);
      bool onCourierMessage(const ButtonReactionMsg& oMsg);

   private:
      DataBindingItem<AddressEntryInputMatchesDataBindingSource> _addressInputNoOfMatches;

      unsigned int _listId;
      unsigned int _startIndex;
      unsigned int _windowElementSize;
      tSharedPtrDataProvider getHierarchicalListDataProvider(unsigned int startIndex, unsigned int windowElementSize) const;
      FEATSTD_MAKE_CLASS_UNCOPYABLE(DestinationMatchListHandler);
};


#endif // HALL_TO_MDW_COM
#endif // DESTINATION_MATCH_LIST_HANDLER_H
