/**************************************************************************************
* @file         : DestinationAddressInputHandlerNarRegion.h
* @author       : Preethi Alagappan
* @addtogroup   : AppHmi_Navigation
* @brief        : Handles change of country in hierarchical address input for NAR region
* @copyright    : (c) 2021 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef DESTINATION_ADDRESS_INPUT_HANDLER_NAR_REGION_H
#define DESTINATION_ADDRESS_INPUT_HANDLER_NAR_REGION_H

#include "DestinationAddressInputHandler.h"

#ifdef HALL_TO_MDW_COM

class DestinationAddressInputHandlerNarRegion : public DestinationAddressInputHandler
{
   public:
      DestinationAddressInputHandlerNarRegion(navmiddleware::NavMiddleware& _navMiddleware, InfoStore& _infoStore);
      virtual ~DestinationAddressInputHandlerNarRegion();
      virtual void initialize();
      virtual void deinitialize();

      void onPropertyUpdateAddressInputInfoChanged();
      void onPropertyUpdateAddressElementChanged();

      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const LeaveFormBasedAddressInputReqMsg& oMsg);

   private:
      bool _isCountryChanged;
      bool _isCountryDataPresent;
      unsigned int _currentCountryIndex;
      navmiddleware::LocationInfos _countryLocationInfos;
      DataBindingItem<ChangeCountryButtonDataBindingSource> _changeCountryButton;

      void onUpdateCountryIcon();
      void setCCPCountryIcon();
      void setCountryIcon(unsigned int countryIndex);

      FEATSTD_MAKE_CLASS_UNCOPYABLE(DestinationAddressInputHandlerNarRegion);
};

#endif
#endif // DESTINATION_ADDRESS_INPUT_HANDLER_NAR_REGION_H
