/**************************************************************************************
* @file         : StringUtils.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef STRING_UTILS_H_
#define STRING_UTILS_H_

#include <string>
#include "CanderaWidget/String/String.h"
#include "FeatStd/Util/TextEncoding.h"

std::string getSubstring(const std::string& stringToExtract, unsigned int fromPos, unsigned int numChar);

void findSubStringHighlightIndex(const Candera::String sourceText, const Candera::String subString, unsigned long& highlightStartIndex, unsigned long& highlightCount, bool ignoreCase = false);
std::string getSubstring(const std::string& stringToExtract, const std::string& separator, unsigned int match);

double stringToDouble(const std::string& inputString);
int stringDecToInt(const std::string& inputString);

#endif // STRING_UTILS_H_
