/**************************************************************************************
* @file         : StaticListHandlerBase.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "gui_std_if.h"
#include "StaticListHandlerBase.h"

#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#include "trcGenProj/Header/StaticListHandlerBase.cpp.trc.h"
#endif

#if defined(HALL_TO_MDW_COM)

bool StaticListHandlerBase::_restorePreviousListPositionRequested = false;

StaticListHandlerBase::StaticListHandlerBase(InfoStore& infoStore)
   : InfoStorePropertyUpdateConsumer(infoStore)
   , _previousFirstVisibleIndex(0)
   , _setLastPositionEnabled(false)
   , _focusLockStatus(STATIC_LIST_FOCUS_UNLOCK)

{
}


StaticListHandlerBase::~StaticListHandlerBase()
{
}


//bool StaticListHandlerBase::onCourierMessage(const ListDateProviderReqMsg& oMsg)
//{
//   if (oMsg.GetListId() == getListId())
//   {
//      updateStaticList();
//      _restorePreviousListPositionRequested = false;
//      return true;
//   }
//   return false;
//}


//bool StaticListHandlerBase::onCourierMessage(const RestorePreviousListPositionReqMsg& oMsg)
//{
//   if (oMsg.GetIsRestoringRequested() != _restorePreviousListPositionRequested)
//   {
//      ETG_TRACE_USR4(("StaticListHandlerBase::onCourierMessage(RestorePreviousListPositionReqMsg(%d)", oMsg.GetIsRestoringRequested()));
//      _restorePreviousListPositionRequested = oMsg.GetIsRestoringRequested();
//   }
//   return true;
//}


//bool StaticListHandlerBase::onCourierMessage(const ListChangedUpdMsg& oMsg)
//{
//   bool msgConsumed = false;
//   if (oMsg.GetListId() == getListId())
//   {
//      ETG_TRACE_USR4(("StaticListHandlerBase::onCourierMessage(ListChangedUpdMsg(listId %d, firstVisibleIndex %d))", getListId(), oMsg.GetFirstVisibleIndex()));
//      _previousFirstVisibleIndex = oMsg.GetFirstVisibleIndex();
//      msgConsumed = handleListChangedUpdMsg(oMsg);
//   }
//   return msgConsumed;
//}


//bool StaticListHandlerBase::onCourierMessage(const ButtonReactionMsg& oMsg)
//{
//   //Forward the button press to unlock(if focus lock is in lock state) the list focus lock details
//   performListFocusLockResetOnButtonPress(oMsg);
//   ListProviderEventInfo info;
//   if (ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info))
//   {
//      unsigned int listId = info.getListId(); // the list id for generic access
//      if ((oMsg.GetEnReaction() == enRelease) && (listId == getListId())) // @todo: handle for all reactions
//      {
//         unsigned int hdlRow = info.getHdlRow(); // normally the index
//         unsigned int hdlCol = info.getHdlCol(); // if more than 1 active element in one list row, e.g. Button in a button line
//
//         ETG_TRACE_USR4(("StaticListHandlerBase::onCourierMessage(ButtonReactionMsg(listID %d, row %d, column %d, speedLock %d))", info.getListId(), info.getHdlRow(), info.getHdlCol(), _infoStore.getSpeedLockState()));
//         if (_infoStore.getSpeedLockState() == InfoStore::SPEEDLOCKSTATE_ON)
//         {
//            if (handleSpeedLockAction(getSpeedLockStatus(hdlRow)))
//            {
//               ETG_TRACE_USR4(("speedlock active %d", hdlRow));
//               return true;
//            }
//         }
//
//         POST_MSG((COURIER_MESSAGE_NEW(ActivateListItemReqMsg)(enRelease, listId, hdlRow, hdlCol)));
//         if (handleButtonReactionMsg(oMsg))
//         {
//            updateStaticList();
//         }
//
//         return true;
//      }
//   }
//   return false;
//}


void StaticListHandlerBase::updateStaticList()
{
   // just post a ListDateProviderResMsg with our settings list data provider
   tSharedPtrDataProvider dataProvider = getListDataProvider();
   if (_setLastPositionEnabled)
   {
      int previousFirstVisibleIndex = 0;

      if (_restorePreviousListPositionRequested)
      {
         previousFirstVisibleIndex = _previousFirstVisibleIndex;
      }

      dataProvider->setListChangeSetIndex(previousFirstVisibleIndex);
   }
   ETG_TRACE_USR4(("StaticListHandlerBase::updateStaticList(listId %d, listSize %d, ListChangeSetIndex %d, _setLastPositionEnabled %d, _restorePreviousListPositionRequested %d)",
                   dataProvider->listId(), dataProvider->listSize(), dataProvider->getListChangeSetIndex(), _setLastPositionEnabled, _restorePreviousListPositionRequested));
   COURIER_MESSAGE_NEW(ListDateProviderResMsg)(dataProvider)->Post();
}


//bool StaticListHandlerBase::onCourierMessage(const ListFocusLockReqMsg& oMsg)
//{
//   //If ListFocusLockReqMsg comes means current list item is following Focus_Progress group then
//   //send ListFocusLockUpdMsg with FocusLockStatus, ListId, RowId, ColumnId
//   //->Info: If focus is not locked send lock update for current item
//   //otherwise send unlock update and reset the all the values(i.e. listId, rowId, columnId)
//   _focusLockStatus = static_cast<enStaticListFocusLockStatus>(((static_cast<uint8_t>(_focusLockStatus)) % 2) + 1); //Toggle between lock and unlock
//   _currentFocusLockListInfo.listId = oMsg.GetListId();
//   _currentFocusLockListInfo.rowId = oMsg.GetRowId();
//   _currentFocusLockListInfo.columnId = oMsg.GetColumnId();
//   ETG_TRACE_USR4(("StaticListHandlerBase:Info:ListFocusLockReqMsg:FocusLockStatus =%d,ListId =%d,RowId =%d,ColumnId =%d", \
//                   _focusLockStatus, _currentFocusLockListInfo.listId, _currentFocusLockListInfo.rowId, _currentFocusLockListInfo.columnId));
//   POST_MSG((COURIER_MESSAGE_NEW(ListFocusLockUpdMsg)(static_cast<uint8_t>(_focusLockStatus), _currentFocusLockListInfo.listId, \
//             _currentFocusLockListInfo.rowId, _currentFocusLockListInfo.columnId)));
//   return true;
//}
//
//
//bool StaticListHandlerBase::onCourierMessage(const ListFocusLockDataResetReqMsg& /*oMsg*/)
//{
//   //Unlock and Clear the last focus locked list informations,
//   //whenever application request.
//   clearLastListFocusLockInfo();
//   return true;
//}


//void StaticListHandlerBase::performListFocusLockResetOnButtonPress(const ButtonReactionMsg& oMsg)
//{
//   //Whenever any button is pressed, Unlock focus of current locked list
//   //(if focus lock is in lock state and not as locked list button)
//   if (_focusLockStatus != STATIC_LIST_FOCUS_UNLOCK)
//   {
//      ListProviderEventInfo info;
//      bool isListButton = ListProviderEventInfo::GetItemIdentifierInfo(oMsg.GetSender(), info);
//      if ((isListButton) && (info.getListId() == _currentFocusLockListInfo.listId) \
//            && (info.getHdlRow() == _currentFocusLockListInfo.rowId))
//      {
//         ETG_TRACE_USR4(("StaticListHandlerBase:Info:Button press is for Focus locked button so no need to unlock"));
//      }
//      else
//      {
//         //Send unlock update to application
//         ETG_TRACE_USR4(("StaticListHandlerBase:Info:Send Focus unlock update"));
//         _focusLockStatus = STATIC_LIST_FOCUS_UNLOCK;
//         POST_MSG((COURIER_MESSAGE_NEW(ListFocusLockUpdMsg)(static_cast<uint8_t>(_focusLockStatus), _currentFocusLockListInfo.listId, \
//                   _currentFocusLockListInfo.rowId, _currentFocusLockListInfo.columnId)));
//      }
//   }
//   else
//   {
//      //ETG_TRACE_USR4(("StaticListHandlerBase:Info:Focus is not locked for any list"));
//   }
//}
//
//
//void StaticListHandlerBase::clearLastListFocusLockInfo()
//{
//   //Unlocking(if focus lock is in lock state) and Clearing the all information about last focus locked list
//   //and update the application via ListFocusLockUpdMsg
//   if (_focusLockStatus != STATIC_LIST_FOCUS_UNLOCK)
//   {
//      //Send unlock update to application
//      ETG_TRACE_USR4(("StaticListHandlerBase:Info:Send Focus unlock update"));
//      _focusLockStatus = STATIC_LIST_FOCUS_UNLOCK;
//      POST_MSG((COURIER_MESSAGE_NEW(ListFocusLockUpdMsg)(static_cast<uint8_t>(_focusLockStatus), _currentFocusLockListInfo.listId, \
//                _currentFocusLockListInfo.rowId, _currentFocusLockListInfo.columnId)));
//   }
//   _currentFocusLockListInfo.listId = 0;
//   _currentFocusLockListInfo.rowId = 0;
//   _currentFocusLockListInfo.columnId = 0;
//   //Send cleared update to application(-> for to clear SM variables)
//   ETG_TRACE_USR4(("StaticListHandlerBase:Info:Send Focus clear update"));
//   POST_MSG((COURIER_MESSAGE_NEW(ListFocusLockUpdMsg)(static_cast<uint8_t>(_focusLockStatus), _currentFocusLockListInfo.listId, \
//             _currentFocusLockListInfo.rowId, _currentFocusLockListInfo.columnId)));
//}
//
//
//bool StaticListHandlerBase::getSpeedLockListElementStatus(unsigned int index)
//{
//   return ((getSpeedLockStatus(index) == SPEEDLOCK_CONFIG_A_RESTRICTED_MENU_ITEM) || (getSpeedLockStatus(index) == SPEEDLOCK_CONFIG_C_RESTRICTED_LIST_ITEM))
//          && (_infoStore.getSpeedLockState() == InfoStore::SPEEDLOCKSTATE_ON);
//}


#endif // HALL_TO_MDW_COM
