/**************************************************************************************
* @file         : PositionWGS84.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <limits.h>
#include "PosWGS84.h"

std::vector<navmiddleware::GeoCoordinateDegree> convert(const std::vector<PosWGS84<double> >& positionVector)
{
   std::vector<navmiddleware::GeoCoordinateDegree> geoCoordinateDegreeVector;
   for (unsigned int i = 0; i < positionVector.size(); ++i)
   {
      geoCoordinateDegreeVector.push_back(navmiddleware::GeoCoordinateDegree(positionVector[i]._latitude, positionVector[i]._longitude));
   }
   return geoCoordinateDegreeVector;
}


const double PI = 3.14159265358979323846;
const double radiusEquator = 6378137.0;

// This function converts decimal degrees to radians
double deg2rad(double deg)
{
   return (deg * PI / 180.0);
}


// This function calculates distance (in meter) between 2 locations
double calculateDistanceInMeter(double lat1d, double lon1d, double lat2d, double lon2d)
{
   double lat1r, lon1r, lat2r, lon2r, u, v;
   lat1r = deg2rad(lat1d);
   lon1r = deg2rad(lon1d);
   lat2r = deg2rad(lat2d);
   lon2r = deg2rad(lon2d);
   u = sin((lat2r - lat1r) / 2);
   v = sin((lon2r - lon1r) / 2);
   return (2.0 * radiusEquator * asin(sqrt(u * u + cos(lat1r) * cos(lat2r) * v * v)));
}
