/**************************************************************************************
* @file         : NavMiddlewareUtils.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <iomanip>
#include "NavMiddlewareUtils.h"
#include "PosWGS84.h"

#if defined(HALL_TO_MDW_COM)

using namespace navmiddleware;

void startGuidanceToPosWGS84(NavMiddleware& navMiddleware, PosWGS84<double> posWGS84)
{
   navMiddleware.setLocationWithCoordinates(posWGS84._latitude, posWGS84._longitude);
   navMiddleware.startRouteCalculationAndGuidance();
   navMiddleware.switchToLinkedMode(MAP_VIEW_ID__PRIMARY);
}


void startGuidanceToPickingResult(NavMiddleware& navMiddleware, const navmiddleware::PickingResults::PickingResult& pickingResult)
{
   navMiddleware.setLocationWithPickingResult(pickingResult);
   navMiddleware.startRouteCalculationAndGuidance();
}


::std::string getCustomizedPOICategory(NavMiddleware& navMiddleware, unsigned int index)
{
   const navmiddleware::LocationCategoryInfos& locationCategoryInfos = navMiddleware.getPoiShortcutCategoryInfos(navmiddleware::LocationContext(
            navmiddleware::LocationContext::HMICONTEXT__GUI, APPLICATIONID__NAVIGATION));
   const ::std::vector<navmiddleware::LocationCategoryInfos::LocationCategoryInfo>& infos = locationCategoryInfos.getLocationCategoryInfos();
   std::string result;

   if (index < infos.size())
   {
      result = infos[index].m_categoryName;
   }

   return result;
}


std::string convertCoordinateFormatToDegMinSec(std::string inputString)
{
   double processValue = 0.0f;
   std::stringstream resultStringStream;
   std::string processString = inputString;

   double degreeValue = 0.0f;
   double minuteValue = 0.0f;
   double secondValue = 0.0f;

   std::string degreeSymbol = "";
   std::string minuteSymbol = "'";
   std::string secondSymbol = "\"";

   processValue = atof(processString.c_str());

   degreeValue = static_cast<double>(static_cast<int>(processValue));
   minuteValue = static_cast<double>(static_cast<int>((processValue - degreeValue) * 60));
   secondValue = static_cast<double>(static_cast<int>((processValue - degreeValue - minuteValue / 60) * 3600));
   resultStringStream << std::setfill('0') << std::setw(2) << degreeValue << degreeSymbol << std::setfill('0') << std::setw(2) << minuteValue << minuteSymbol << std::setfill('0') << std::setw(2) << secondValue << secondSymbol;
   processString = resultStringStream.str();

   return processString;
}


Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D> getCustomizedPOIIcon(navmiddleware::NavMiddleware& navMiddleware, unsigned int index)
{
   const navmiddleware::LocationCategoryInfos& locationCategoryInfos = navMiddleware.getPoiShortcutCategoryInfos(navmiddleware::LocationContext(
            navmiddleware::LocationContext::HMICONTEXT__GUI, APPLICATIONID__NAVIGATION));
   const ::std::vector<navmiddleware::LocationCategoryInfos::LocationCategoryInfo>& infos = locationCategoryInfos.getLocationCategoryInfos();

   if (index < infos.size())
   {
      return loadImage((const char*)infos[index].m_imageBlob, infos[index].m_imageBlobLength, true);
   }
   else
   {
      return Candera::MemoryManagement::SharedPointer<Candera::BitmapImage2D>(NULL);
   }
}


unsigned int mapManeuverOrDirectionSymbolIndex(const navmiddleware::ManeuverSymbolType& maneuverSymbolType, const navmiddleware::ManeuverSymbol maneuver,
      const navmiddleware::DirectionDescription& destDirection, const navmiddleware::DirectionDescription& entryPointDirection, bool isValid)
{
   unsigned int mappedSymbol = emptyManeuverSymbol;
   if (maneuverSymbolType == MANEUVER_SYMBOL)
   {
      if (maneuver > 1) // SceneComposer has unused bitmaps for index 0 and 1
      {
         mappedSymbol = static_cast<unsigned int>(maneuver);
      }
   }
   else if (maneuverSymbolType == DESTINATION_DIRECTION_SYMBOL)
   {
      mappedSymbol = static_cast<unsigned int>(destDirection) + MANEUVER_DIRECTION_SYMBOL_OFFSET;
   }
   else if ((maneuverSymbolType == ROAD_ENTRY_POINT_DIRECTION_SYMBOL) && isValid)
   {
      mappedSymbol = static_cast<unsigned int>(entryPointDirection) + MANEUVER_DIRECTION_SYMBOL_OFFSET;
   }
   return mappedSymbol;
}


#endif // HALL_TO_MDW_COM
