/**************************************************************************************
* @file         : NavMiddlewareStartup.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef NAVMIDDLEWARESTARTUP_H
#define NAVMIDDLEWARESTARTUP_H 1

#include "PosWGS84.h"
#include "InfoStore.h"

#if defined(HALL_TO_MDW_COM)

bool initializeMiddleware(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
bool reinitializeMiddleware(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
void setMiddlewareConfigurationInformation(InfoStore& infoStore, navmiddleware::ConfigurationInfos& configurationInfos);
bool checkNavMiddlewareVersion(navmiddleware::NavMiddleware& navMiddleware);

void startNavigationLimitedModeTimer(void);
void deactivateNavigationLimitedMode(navmiddleware::NavMiddleware& navMiddleware);

#endif // HALL_TO_MDW_COM
#endif // NAVMIDDLEWARESTARTUP_H
