/**************************************************************************************
* @file         : InfoStorePropertyUpdateConsumer.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef INFO_STORE_PROPERTY_UPDATE_CONSUMER_H
#define INFO_STORE_PROPERTY_UPDATE_CONSUMER_H

#include "HMIModelDefines.h"
#include "InfoStore.h"
#include "InfoStorePropertyUpdateCallback.h"

#if defined(HALL_TO_MDW_COM)

/**
* Base class for property update from info store
*/
class InfoStorePropertyUpdateConsumer : public InfoStorePropertyUpdateCallback
{
   public:
      InfoStorePropertyUpdateConsumer(InfoStore& infoStore);
      virtual ~InfoStorePropertyUpdateConsumer();

   protected:
      /** global info store container */
      InfoStore& _infoStore;

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(InfoStorePropertyUpdateConsumer);
};


#endif // HALL_TO_MDW_COM
#endif // INFO_STORE_PROPERTY_UPDATE_CONSUMER_H
