/**************************************************************************************
* @file         : InfoStorePropertyUpdateCallback.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef INFO_STORE_PROPERTY_UPDATE_CALLBACK_H
#define INFO_STORE_PROPERTY_UPDATE_CALLBACK_H

#include "HMIModelDefines.h"
#include "InfoStorePropertyIdentifiers.h"

/** property update defines */
#define PROPERTY_UPDATE_INFOSTORE_BEGIN() \
   virtual bool onPropertyUpdate(const InfoStorePropertyIdentifier& propertyIdentifier) \
   { \

#define ON_PROPERTY_INFOSTORE_UPDATE(_property_, _method_) \
   if (_property_ == propertyIdentifier) \
   { \
      return _method_(); \
   } \

#define ON_PROPERTY_INFOSTORE_UNUSED() \
   COURIER_UNUSED(propertyIdentifier);

#define PROPERTY_UPDATE_INFOSTORE_END() \
      return false;\
   } \

class InfoStoreCallbackManager;

class InfoStorePropertyUpdateCallback
{
   public:
      InfoStorePropertyUpdateCallback(InfoStoreCallbackManager& infoStoreCallbackManager);
      virtual ~InfoStorePropertyUpdateCallback();

      virtual bool onPropertyUpdate(const InfoStorePropertyIdentifier& propertyIdentifier) = 0;

      InfoStoreCallbackManager& _infoStoreCallbackManager;

   private:
      InfoStorePropertyUpdateCallback();

      FEATSTD_MAKE_CLASS_UNCOPYABLE(InfoStorePropertyUpdateCallback);
};


#endif // INFO_STORE_PROPERTY_UPDATE_CALLBACK_H
