/**************************************************************************************
* @file         : InfoStoreCallbackManager.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef INNFO_STORE_CALLBACK_MANAGER_H
#define INNFO_STORE_CALLBACK_MANAGER_H

#include "HMIModelDefines.h"
#include "InfoStorePropertyIdentifiers.h"

class InfoStorePropertyUpdateCallback;

typedef std::vector<InfoStorePropertyUpdateCallback*> InfoStoreCallbackVector;

class InfoStoreCallbackManager
{
   public:
      InfoStoreCallbackManager();
      virtual ~InfoStoreCallbackManager();

      void registerDataPropertyUpdateCallback(InfoStorePropertyUpdateCallback& elem);
      void unregisterDataPropertyUpdateCallback(InfoStorePropertyUpdateCallback& elem);
      void notify(const InfoStorePropertyIdentifier propertyIdentifier);

   protected:
      InfoStoreCallbackVector _infoStoreCallbackVector;
};


#endif // INNFO_STORE_CALLBACK_MANAGER_H
