/**************************************************************************************
* @file         : HMIModelTypes.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_HMI_MODEL_TYPES_H)
#define _HMI_MODEL_TYPES_H


#include "HmiTranslation_TextIds.h"
#define TEXTID_UNAVAILABLE 0xFFFFFFFF
#define textID TEXTID_UNAVAILABLE
#define LANGUAGE_STRING(text_id, text) ((text_id==TEXTID_UNAVAILABLE) ? text : Candera::String(text_id))

enum IsVisible
{
   IS_VISIBLE_FALSE,
   IS_VISIBLE_TRUE
};


enum IsButtonToggleEnabled
{
   BUTTON_TOGGLE_ENABLED_TRUE,
   BUTTON_TOGGLE_ENABLED_FALSE
};


enum ChoiceImageIndexes
{
   CHOICE_INDEX_FIRST = 0,
   CHOICE_INDEX_SECOND,
   CHOICE_INDEX_THIRD
};


enum ListButtonType
{
   LIST_BUTTON_TYPE_BUTTON,
   LIST_BUTTON_TYPE_TOGGLE,
   LIST_BUTTON_TYPE_DROPDOWN,
   LIST_BUTTON_TYPE_SUB_MENU_TEXT,
   LIST_BUTTON_TYPE_CHOICE_TWO_IMAGES,
   LIST_BUTTON_TYPE_CHOICE_ONE_IMAGE,
   LIST_BUTTON_TYPE_CHOICE_THREE_IMAGES,
   LIST_BUTTON_TYPE_INC_DEC_VALUE,
   LIST_BUTTON_TYPE_MENU_BUTTON,
   LIST_BUTTON_TYPE_TOGGLE_INFOSTORE
};


typedef Candera::String(*getButtonSubMenuTextFP)(navmiddleware::NavMiddleware& navMiddleware);
typedef IsButtonToggleEnabled(*getButtonToggleStateFP)(navmiddleware::NavMiddleware& navMiddleware);
typedef ChoiceImageIndexes(*getButtonChoiceImageIndexFP)(navmiddleware::NavMiddleware& navMiddleware);


//For Clock Interface
struct LocalTimeDateType
{
   short int s16Year;
   unsigned short int u8Month;
   unsigned short int u8Day;
   unsigned short int u8Hours;
   unsigned short int u8Minutes;
   unsigned short int u8Seconds;
   unsigned short int u8Weekday;

   LocalTimeDateType(): s16Year(0), u8Month(0), u8Day(0), u8Hours(0), u8Minutes(0), u8Seconds(0), u8Weekday(0) {}
};


/**
* Base data class for list items
*/
template <typename T>
struct ListItemBase
{
   ListItemBase(Candera::String text, IsVisible isVisible, ListButtonType listButtonType, T order, getButtonSubMenuTextFP func, getButtonChoiceImageIndexFP choiceImageIndexFunc = NULL)
      : _text(text)
      , _dropDownText("")
      , _dropDownListId(0)
      , _isVisible(isVisible)
      , _listButtonType(listButtonType)
      , _order(order)
      , _listItemName("")
      , getButtonToggleState(NULL)
      , getButtonSubMenuText(func)
      , getButtonChoiceImageIndex(choiceImageIndexFunc) {}

   ListItemBase(Candera::String text, IsVisible isVisible, ListButtonType listButtonType, T order, std::string listItemName)
      : _text(text)
      , _dropDownText("")
      , _dropDownListId(0)
      , _isVisible(isVisible)
      , _listButtonType(listButtonType)
      , _order(order)
      , _listItemName(listItemName)
      , getButtonToggleState(NULL)
      , getButtonSubMenuText(NULL)
      , getButtonChoiceImageIndex(NULL) {}

   ListItemBase(Candera::String text, IsVisible isVisible, ListButtonType listButtonType, T order, getButtonToggleStateFP func = 0)
      : _text(text)
      , _dropDownText("")
      , _dropDownListId(0)
      , _isVisible(isVisible)
      , _listButtonType(listButtonType)
      , _order(order)
      , _listItemName("")
      , getButtonSubMenuText(NULL)
      , getButtonToggleState(func)
      , getButtonChoiceImageIndex(NULL) {}

   ListItemBase(Candera::String text, IsVisible isVisible, ListButtonType listButtonType, T order, Candera::String dropDownText, Candera::UInt32 dropDownListId, getButtonToggleStateFP func = 0)
      : _text(text)
      , _dropDownText(dropDownText)
      , _dropDownListId(dropDownListId)
      , _isVisible(isVisible)
      , _listButtonType(listButtonType)
      , _order(order)
      , _listItemName("")
      , getButtonSubMenuText(NULL)
      , getButtonToggleState(func)
      , getButtonChoiceImageIndex(NULL) {}

   getButtonSubMenuTextFP getButtonSubMenuText;
   getButtonToggleStateFP getButtonToggleState;
   getButtonChoiceImageIndexFP getButtonChoiceImageIndex;

   Candera::String _text;
   Candera::String _dropDownText;
   Candera::UInt32 _dropDownListId;
   IsVisible _isVisible;
   ListButtonType _listButtonType;
   T _order;
   std::string _listItemName;
};


namespace App {
namespace DataModel {
namespace util {

class MultiLangTextBuilder
{
   public:
      MultiLangTextBuilder() {}
      virtual ~MultiLangTextBuilder() {}

      template<typename T>
      void AddData(const T& data)
      {
         std::stringstream stringStream;
         stringStream << _text.GetCString() << data;
         std::string dataStr = stringStream.str();
         replace(dataStr.begin(), dataStr.end(), '\r', ',');
         replace(dataStr.begin(), dataStr.end(), '\n', ' ');
         _text = Candera::String(dataStr.c_str());
      }

      void AddData(const Candera::String& data)
      {
         if (_text.IsEmpty())
         {
            _text = data;
         }
         else
         {
            std::stringstream stringStream;
            stringStream << _text.GetCString() << data.GetCString();
            _text = Candera::String(stringStream.str().c_str());
         }
      }

      Candera::String GetData() const
      {
         return _text;
      }

   private:
      Candera::String _text;
};


}
}


}

#endif // _HMI_MODEL_TYPES_H
