/**************************************************************************************
* @file         : HMIModelBase.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) -2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_BASE_H
#define HMI_MODEL_BASE_H

#include "HMIModelDefines.h"
#include "NavMiddlewarePropertyUpdateConsumer.h"
#include "InfoStorePropertyUpdateConsumer.h"

#ifdef HALL_TO_MDW_COM

/**
* Base class for sub hmi models
*/
class HMIModelBase : public NavMiddlewarePropertyUpdateConsumer, public InfoStorePropertyUpdateConsumer
{
   public:
      friend class HMIModelComponent;

      HMIModelBase(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelBase();

      /** Called when sub model component should initialize itself */
      virtual void initialize() = 0;

      /** Called when sub model component should deinitialize itself */
      virtual void deinitialize() = 0;

      /** Called when sub model component should handle navigation data update start */
      virtual void navDataUpdateStarted() {};

      /** Called when sub model component should handle navigation data update finished */
      virtual void navDataUpdateFinished() {};

      /** Called when sub model component should handle navigation data update recovery */
      virtual void recoverNavData() {};

      /** Sets the model to initialized state */
      void setInitialized()
      {
         _isInitialized = true;
         _isNavDataUpdateRecovery = false;
      }

      /** Sets the model to deinitialized state */
      void setDeinitialized()
      {
         _isInitialized = false;
      }

      /** Getter for submodules to check if they are initialized */
      bool isInitialized() const
      {
         return _isInitialized;
      }

      /** Sets the model to navigation data update running state */
      void setNavDataUpdateStarted()
      {
         _isNavDataUpdateRunning = true;
      }

      /** Sets the model to navigation data update finished state */
      void setNavDataUpdateFinished()
      {
         _isNavDataUpdateRunning = false;
         _isNavDataUpdateRecovery = false;
      }

      /** Sets the model to navigation data update recovery state */
      void setNavDataUpdateRecovery()
      {
         _isNavDataUpdateRecovery = true;
      }

      /** Getter for submodules to check if they a navigation data update is running */
      bool isNavDataUpdateRunning() const
      {
         return _isNavDataUpdateRunning;
      }

      /** Getter for submodules to check if they a navigation data recovery is running */
      bool isNavDataUpdateRecovery() const
      {
         return _isNavDataUpdateRecovery;
      }

   private:
      HMIModelBase();

      bool _isInitialized;
      bool _isNavDataUpdateRunning;
      bool _isNavDataUpdateRecovery;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelBase);
};


#endif // HALL_TO_MDW_COM
#endif // HMI_MODEL_BASE_H
