/**
 * @file        :  CommonUnitsUtility.h
 * @addtogroup  :  AppHmi_App_Common
 * @brief       :  Contains all utility methods used for Distance and Speed calculations
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef COMMON_DISTANCE_UTILITY_H
#define COMMON_DISTANCE_UTILITY_H

#include <hmibase/sys_std_if.h>

//Temperature unit type based on "di_cfc\components\vd_VehicleData\fi\cca\vehicle_fi\vehicle_main_fi\vehicle_main_fi.pdf"
enum eTempType
{
   EN_FAHRENHEIT = 1,
   EN_CELSIUS
};


enum eHeightType
{
   EN_MILLIMETER = 0,
   EN_INCHES
};


//Distance unit type based on "di_cfc\components\vd_VehicleData\fi\cca\vehicle_fi\vehicle_main_fi\vehicle_main_fi.pdf"
enum eDistanceUnitType
{
   EN_MILES = 1,
   EN_KM
};


class CommonUnitsUtility
{
   public:
      enum eCoordinatesType
      {
         EN_LATITUDE = 0,
         EN_LONGITUDE
      };

      enum eCoordinatesDisplayFormat
      {
         EN_DECIMAL = 0,
         EN_SEXAGESIMAL
      };

      enum eCoordinateDirection
      {
         NORTH = 0,
         EAST,
         SOUTH,
         WEST
      };

      typedef struct
      {
         std::string decimal;
         std::string fraction;
         std::string degree;
         std::string minute;
         std::string second;
         eCoordinateDirection direction;
      } sCoordinateInfo;

      virtual ~CommonUnitsUtility();
      CommonUnitsUtility();
      std::string convertDistance(float distance, eDistanceUnitType fromDistType, eDistanceUnitType toDistType);
      //   std::string convertTemperature(int16 temp, eTempType fromTempType, eTempType toTempType);
      std::string convertSpeed(unsigned int speed, eDistanceUnitType fromSpeedType, eDistanceUnitType toSpeedType);
      //  uint32 convertHeight(unsigned int height, eHeightType fromHeightType, eHeightType toHeightType);
      void convertPressure(void);
      sCoordinateInfo convertCoordinateDisplayFormat(const std::string& processString, eCoordinatesType coordinatesDisplayType, eCoordinatesDisplayFormat coordinatesDisplayFormat);
      //Region types available in "\nincg3_GEN\ai_projects\generated\components\vd_vehicledata\Scope2\UnitList.h"
      enum eRegionType
      {
         EN_USA = 0,
         EN_CAN,
         EN_MEX,
         EN_UK
      };
      void setRegionType(eRegionType region)
      {
         _uRegionType = (tU8)region;
      }

   private:
      tU8 _uRegionType;
      std::string getSubstring(std::string stringToExtract, unsigned int fromPos, unsigned int numChar);
      double stringToDouble(std::string processString);
      std::string to_string(double const& value);
      void americanUnitHandler(std::ostringstream&, float);
      void britishUnitHandler(std::ostringstream&, float);
      unsigned int roundUpToInteger(unsigned int numToRound, unsigned int multiple);
      std::string convertDistanceToString(float flValue);
      sCoordinateInfo ConvertToSexagesimalFormat(const std::string& inputString, eCoordinatesType coordinatesDisplayType);
      sCoordinateInfo ConvertToDecimalFormat(const std::string& inputString, eCoordinatesType coordinatesDisplayType);
};


#endif//COMMON_DISTANCE_UTILITY_H
