/**************************************************************************************
* @file         : HMIModelNavigationServiceExtended.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#if !defined(_HMI_MODEL_NAVIGATION_SERVICE_EXTENDED_H)
#define _HMI_MODEL_NAVIGATION_SERVICE_EXTENDED_H

#include "Common/Util/HMIModelIncludes.h"
#include "org/bosch/cm/navigation/NavigationServiceStub.h"

/**
 * HMIModelNavigationServiceExtended provides Nissan and Renault specific implementation.
 */
class HMIModelNavigationServiceExtended : public HMIModelBase
{
   public:
      HMIModelNavigationServiceExtended(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore, org::bosch::cm::navigation::NavigationService::NavigationServiceStub& navigationServiceStub) : HMIModelBase(navMiddleware, infoStore)
         , _navMiddleware(navMiddleware)
         , _navigationServiceStub(navigationServiceStub)
         , _getStartRouteCalculationToDestinationAct(0)
      {
      }
      ~HMIModelNavigationServiceExtended();

      virtual void initialize() {}
      virtual void deinitialize() {}

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_MSG_MAP_END()

      void showLocationDetails(void);
      void InsertWaypoint(unsigned int);
      void InsertWaypointAtDefaultPosition(void);

   private:

      act_t _getStartRouteCalculationToDestinationAct;

      navmiddleware::NavMiddleware& _navMiddleware;
      org::bosch::cm::navigation::NavigationService::NavigationServiceStub& _navigationServiceStub;
};


#endif // _HMI_MODEL_NAVIGATION_SERVICE_EXTENDED_H
