/**************************************************************************************
* @file         : HMIModelNavigationServiceExtended.cpp
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "Common/Service/HMIModelNavigationServiceExtended.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_DM
#include "trcGenProj/Header/HMIModelNavigationServiceExtended.cpp.trc.h"
#endif

static const int MAX_WAYPOINT = 9;

using namespace ::org::bosch::cm::navigation::NavigationService;
using namespace navmiddleware;

HMIModelNavigationServiceExtended::~HMIModelNavigationServiceExtended()
{
}


void HMIModelNavigationServiceExtended::showLocationDetails()
{
   //Dummy implementation provided, INF4CV specific implementaion to be added if required.
   ETG_TRACE_USR1(("HMIModelNavigationServiceExtended::showLocationDetails(): currenly not implemented"));
}


void HMIModelNavigationServiceExtended::InsertWaypoint(unsigned int index)
{
   ETG_TRACE_USR4(("HMIModelNavigationServiceExtended::InsertWaypoint(): %d", index));
   _infoStore.setWaypointIndex(index);
   /* @ToDo: Implementation to be added if required
   POST_MSG((COURIER_MESSAGE_NEW(InsertWaypointReqMsg)(true))); */
}


void HMIModelNavigationServiceExtended::InsertWaypointAtDefaultPosition(void)
{
   ETG_TRACE_USR4(("HMIModelNavigationServiceExtended::InsertWaypointAtDefaultPosition()"));

   /*WayPoint has to be inserted as a new entry to waypoint list when insertwaypoint request is for default position*/
   unsigned int waypointListSize = _infoStore.getWaypointListSize();
   if (waypointListSize < MAX_WAYPOINT)
   {
      POST_MSG((COURIER_MESSAGE_NEW(WaypointInsertReqMsg)()));
   }
}
