/**************************************************************************************
* @file         : HMIModelNavigationSDSService.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef HMI_MODEL_NAVIGATION_SDS_SERVICE_H
#define HMI_MODEL_NAVIGATION_SDS_SERVICE_H

#include "Common/Util/HMIModelIncludes.h"

#if defined(HALL_TO_MDW_COM)
#if defined(HALL_NAVIGATION_SDS_SERVICE)

#include "org/bosch/cm/navigation/NavigationSDSServiceStub.h"
#include "ActQueue.h"

/**
 * HMIModelNavigationSDSService provides the dbus service for the navigation
 */
class HMIModelNavigationSDSService : public HMIModelBase, public org::bosch::cm::navigation::NavigationSDSService::NavigationSDSServiceStub
{
   public:
      HMIModelNavigationSDSService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelNavigationSDSService();

      virtual void initialize();
      virtual void deinitialize();

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_GLOBAL_DATA_CHANGED, onPropertyUpdateGlobalDataForSdsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_NAMES_FOR_NDS_IDS_CHANGED, onPropertyUpdateNamesForNdsIdsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_PHONEMES_FOR_NDS_IDS_CHANGED, onPropertyUpdateLocationSDSPhonemesForNDSIdsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_ID_LIST_COUNTRY_AND_SUBCOUNTRY_CHANGED, onPropertyUpdateCountryAndSubCountryChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_CITY_HAS_STREETS_CHANGED, onPropertyUpdateCityHasStreetsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_INFO_CHANGED, onPropertyUpdatePositionInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::POSITION_STATUS_CHANGED, onPropertyPositionStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADRESS_INPUT_INFO_CHANGED, onPropertyUpdateAddressInputInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_ADDRESS_WITH_OPTIONS_CHANGED, onPropertySdsAddressWithOptionsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_PATTERNS_CHANGED, onPropertyUpdateSdsHouseNumberPatternsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_SDS_ELEMENTS_CHANGED, onPropertyUpdateSdsElementsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::LOCATION_ADDRESS_FORMAT_AVAILABLE, onPropertyUpdateAddressFormatForAvailableCountries)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_DATASET_INFO_CHANGED, onPropertyNavDataSetInfoChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_DATASET_USER_REG_CHANGED, onPropertyNavDataUserRegChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyUpdateGlobalDataForSdsChanged();
      void onPropertyUpdateNamesForNdsIdsChanged();
      void onPropertyUpdatePositionInfoChanged();
      void onPropertyPositionStatusChanged();
      void onPropertyUpdateCountryAndSubCountryChanged();
      void onPropertyUpdateCityHasStreetsChanged();
      void onPropertyUpdateLocationSDSPhonemesForNDSIdsChanged();
      void onPropertyUpdateAddressInputInfoChanged();
      bool onPropertySdsAddressWithOptionsChanged();
      bool onPropertyUpdateSdsHouseNumberPatternsChanged();
      bool onPropertyUpdateSdsElementsChanged();
      void onPropertyUpdateAddressFormatForAvailableCountries();
      void onPropertyNavDataSetInfoChanged();
      void onPropertyNavDataUserRegChanged();

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SetNaviSDSHandoverScreenIDReqMsg)
      ON_COURIER_MESSAGE(SetNaviSdsFTSOptionReqMsg)
      COURIER_MSG_MAP_END()

      // Incoming requests from navigation service
      virtual void onGetGlobalDataForSdsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetGlobalDataForSdsRequest >& /*request*/);
      virtual void onGetIdListOfCountryAndSubCountryRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetIdListOfCountryAndSubCountryRequest >& /*request*/);
      virtual void onGetNamesForNDSIdsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetNamesForNDSIdsRequest >& /*request*/);
      virtual void onGetPhonemesForNDSIdsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetPhonemesForNDSIdsRequest >& /*request*/);
      virtual void onGetCityHasStreetsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetCityHasStreetsRequest >& /*request*/);
      virtual void onNdsDatasetReleasedRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::NdsDatasetReleasedRequest >& /*request*/);
      virtual void onGetHapticHandOverDataRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::GetHapticHandOverDataRequest >& /*request*/);
      virtual void onSelectHapticHandOverListRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SelectHapticHandOverListRequest >& /*request*/);
      virtual void onGetDynamicPoiIconCategoriesInMapRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::GetDynamicPoiIconCategoriesInMapRequest>& /*request*/);
      virtual void onSetDynamicPoiIconCategoriesInMapRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SetDynamicPoiIconCategoriesInMapRequest>& /*request*/);
      virtual void onSetLocationWithSdsInputRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SetLocationWithSdsInputRequest>& /*request*/);
      virtual void onSdsCheckAddressRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SdsCheckAddressRequest>& request);
      virtual void onSdsGetRefinementListRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsGetRefinementListRequest >& request);
      virtual void onSelectSdsRefinementRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SelectSdsRefinementRequest>& /*request*/);
      virtual void onGetMaxWaypointCountRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::GetMaxWaypointCountRequest>& request) {};
      virtual void onSdsDatasetUserRegistrationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserRegistrationRequest>& request);
      virtual void onSdsDatasetUserDeregistrationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SdsDatasetUserDeregistrationRequest>& request);

      virtual void onSdsGetHouseNumberPatternRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SdsGetHouseNumberPatternRequest>& request);
      virtual void onSdsUpdateVoiceTagRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::SdsUpdateVoiceTagRequest>& request);
      virtual void onSdsShowReachableAreaMapRequest(const boost::shared_ptr< org::bosch::cm::navigation::NavigationSDSService::SdsShowReachableAreaMapRequest>& /*request*/);
      virtual void onRequestAddressFormatForAvailableCountriesRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::RequestAddressFormatForAvailableCountriesRequest>& /*request*/);
      virtual void onDatasetAccessModeChangedIndicationRequest(const boost::shared_ptr<org::bosch::cm::navigation::NavigationSDSService::DatasetAccessModeChangedIndicationRequest>& request);

      bool onCourierMessage(const SetNaviSDSHandoverScreenIDReqMsg& oMsg);
      bool onCourierMessage(const SetNaviSdsFTSOptionReqMsg& oMsg);

   private:
      act_t _getGlobalDataForSdsAct;
      ActQueue _getNamesForNDSIdsAct;
      ActQueue _getPhonemesForNDSIdsAct;
      act_t _getIdListOfCountryAndSubCountryAct;
      act_t _getCityHasStreetsAct;
      act_t _getBaseAddressFTSAct;
      act_t _getBaseAddressPOIAct;
      act_t _getBaseAddressStartRouteAct;
      act_t _getFTSConfirmPOIorAddressAct;
      act_t _sdsCheckAddressRequestAct;
      act_t _selectSdsRefinementAct;
      act_t _getHouseNumberPatternAct;
      act_t _getSdsGetRefinementListAct;
      act_t _getAddressFormatForAvailableCountriesAct;
      act_t _getRegisterDatasetUserAct;
      act_t _getDeregisterDatasetUserAct;
      enum Hand_Over_Data_Type
      {
         HAND_OVER_NONE,
         HAND_OVER_SINGLE,
         HAND_OVER_LIST,
         HAND_OVER_MULTIPLE
      };
      Hand_Over_Data_Type checkHandOverDataType(unsigned int listSize);
      Hand_Over_Data_Type checkHandOverDataTypeCandidateList(unsigned int listSize, bool candidateListVisible);
      void updateDataListHandOver(const Hand_Over_Data_Type handOverType, const navmiddleware::LocationInfos& locationInfos, std::vector< org::bosch::cm::navigation::NavigationSDSService::HapticData >& dataList);
      void updateSelectedDataItem(bool addCountry, bool addState, bool addCity, bool addHouseNo, bool addStreet, bool addCrosStreet, std::vector<org::bosch::cm::navigation::NavigationSDSService::SelectedDataItem>& selectedDataList);

      void constructSDSUpdateRegionsList(const ::std::vector<navmiddleware::SdsUpdateRegionInfo>& sdsUpdateRegionsList, std::vector<org::bosch::cm::navigation::NavigationSDSService::SdsUpdateRegions>& SdsUpdateRegion);
      void constructSDSBuildingBlocks(const ::std::vector<navmiddleware::SdsBuildingBlockInfo>& sdsBuildingBlockInfo, std::vector<org::bosch::cm::navigation::NavigationSDSService::SdsBuildingBlocks>& sdsBuildingBlocksList);
      void constructSDSRegionMetadata(const ::std::vector<navmiddleware::SdsRegionMetaDataInfo>& sdsRegionMetaDataInfo, std::vector<org::bosch::cm::navigation::NavigationSDSService::SdsRegionMetadata>& sdsRegionMetadataList);
      void constructSDSLanguages(const ::std::vector<navmiddleware::SdsLanguageInfo>& SdsLanguageInfo, std::vector<org::bosch::cm::navigation::NavigationSDSService::SdsLanguages>& sdsLanguagesList);
      void constructSDSSubCountryIdList(const std::vector<navmiddleware::SdsGlobalNamedObjectIdWithPoiAndXrefIdInfo>& sdsGlobalNamedObjectIdInfos, std::vector<org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectAndRegionId>& subCountryIds);
      void constructSDSGlobalUpdateRegionId(const navmiddleware::SdsGlobalUpdateRegionInfo& sdsGlobalUpdateRegionInfo, org::bosch::cm::navigation::NavigationSDSService::GlobalUpdateRegionId& globalUpdateRegionId);
      void constructMWGlobalNamedObjectIdList(const std::vector<org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId>& globalNamedObjectIds, std::vector<navmiddleware::SdsGlobalNamedObjectIdInfo>& sdsGlobalNamedObjectIdInfos);
      void constructMWLanguageEntryList(const std::vector<org::bosch::cm::navigation::NavigationSDSService::LanguageEntry>& languageEntryList, std::vector<navmiddleware::LanguageEntryInfo>& languageEntryInfos);
      void constructSDSNdsIds(const std::vector<navmiddleware::SdsNdsIdStringInfo>& sdsNdsIdStringInfos, std::vector<org::bosch::cm::navigation::NavigationSDSService::NamedObjectIdStrings>& namedObjectIdStringsList);
      org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId constructSDSGlobalNameID(const navmiddleware::ValidValue<navmiddleware::SdsGlobalNamedObjectIdInfo>& SdsGlobalNamedObjectIdInfo);
      org::bosch::cm::navigation::NavigationSDSService::GlobalNamedObjectId constructSDSGlobalNameID(const navmiddleware::SdsGlobalNamedObjectIdInfo& SdsGlobalNamedObjectIdInfo);
      // Haptical handOver data
      void updateFreeTextSearchAddressHandOver();
      void updateFreeTextSearchCandidateListHandOver();
      void updateStreetAddressEnterStateHandOver();
      void updateCountryHandOver();
      void updateStreetAddressHouseNumberStreetHandOver();
      void updateStreetAddressHouseNumberStreetCityHandOver();
      void updateStreetAddressMainWithoutStateHandOver();
      void updateStreetAddressCityFirstCityHandOver();
      void updateStreetAddressCityFirstHouseNumberHandOver();
      void updateStreetAddressCityFirstHouseNumberStreetHandOver();
      void updateStreetAddressAmbiguityHandOver();
      void updateCityCenterAmbiguityHandOver();
      void updateInterSectionStreetFirstHandOver();
      void updateInterSectionAmbigutyHandOver();
      void updatePOICategoryHandOver();
      void updatePOIListHandOver();
      void updatePOIInCityHandOver();
      void updatePOIStateHandOver();
      void updatePOICountryHandover();
      void updateSetDestStartRGHandover();
      void updateSetDestAddressHandover();
      void updateSetDestCityCenterHandover();
      void updateSetDestIntersectionHandover();
      void updateSetDestPOIHandover();

      enSDSHandoverScreenID _naviSdsHandOverSreenId;
      enSDSHandoverScreenID _currentRGFlow;

      // type conversion helper
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationSDSService);
};


#else // HALL_NAVIGATION_SDS_SERVICE

class HMIModelNavigationSDSService : public HMIModelBase
{
   public:
      HMIModelNavigationSDSService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore) : HMIModelBase(navMiddleware, infoStore) {}
      virtual ~HMIModelNavigationSDSService() {};

      virtual void initialize() {};
      virtual void deinitialize() {};

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
#pragma warning(disable : 4065)
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY() // LINT Info 764
      COURIER_MSG_MAP_END()

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationSDSService);
};


#endif // HALL_NAVIGATION_SDS_SERVICE
#endif // HALL_TO_MDW_COM
#endif // _HMI_MODEL_NAVIGATION_SERVICE_H
