/**************************************************************************************
* @file         : HMIModelNavigationDataUpdateService.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _HMI_MODEL_NAVIGATION_DATAUPDATE_SERVICE_H
#define _HMI_MODEL_NAVIGATION_DATAUPDATE_SERVICE_H

#include "Common/Util/HMIModelIncludes.h"
#define NAVDATA_DEVICEID__UNKNOWN 255
#if defined(HALL_TO_MDW_COM)
#if defined(HALL_NAVIGATION_DATAUPDATE_SERVICE)

#include "org/bosch/cm/navigation/NavigationDataUpdateServiceStub.h"


class HMIModelNavigationDataUpdateService : public HMIModelBase, public org::bosch::cm::navigation::NavigationDataUpdateService::NavigationDataUpdateServiceStub
{
   public:
      HMIModelNavigationDataUpdateService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore);
      virtual ~HMIModelNavigationDataUpdateService();

      virtual void initialize();
      virtual void deinitialize();
      virtual void recoverNavData();

      virtual void onDiagPerformFullUpdateViaUSBRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::DiagPerformFullUpdateViaUSBRequest >& request);
      virtual void onGetAvailableUpdatesRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::GetAvailableUpdatesRequest >& request);
      virtual void onDeleteUpdateComponentRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::DeleteUpdateComponentRequest >& request);
      virtual void onSetFavoriteUpdateRegionsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::SetFavoriteUpdateRegionsRequest >& request);
      virtual void onClearFavoriteUpdateRegionsRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::ClearFavoriteUpdateRegionsRequest >& request);
      virtual void onStartFullUpdateRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::StartFullUpdateRequest >& request);
      virtual void onStartMapDataExportRequest(const ::boost::shared_ptr< org::bosch::cm::navigation::NavigationDataUpdateService::StartMapDataExportRequest >& request);

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_STATUS_CHANGED, onPropertyNavDataUpdateStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_NAVDATA_STATUS_CHANGED, onPropertyNavigationDataStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_CONTEXT_CHANGED, onPropertyNavDataContextChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_COMPONENT_DEINSTALL_RESULT_CHANGED, onPropertyNavDataUpdateComponentDeinstallResultChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_FAVORITE_REGION_SETTINGS_RESULT_CHANGED, onPropertyNavDataUpdateFavoriteRegionSettingsResultChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_FAVORITE_REGION_SETTINGS_CHANGED, onPropertNavDataUpdateFavoriteRegionSettingsChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_DEVICE_STATUS_CHANGED, onPropertyNavDataUpdateDeviceStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_CATALOGUE_STATUS_CHANGED, onPropertyNavDataUpdateCatalogueStatusChanged)
      ON_PROPERTY_MIDDLEWARE_UPDATE(navmiddleware::NAVDATAUPDATE_UPDATE_PREPARATION_STATUS_CHANGED, onPropertyUpdatePreparationStatusChanged)
      PROPERTY_UPDATE_MIDDLEWARE_END()

      void onPropertyNavDataUpdateStatusChanged();

      void onPropertyNavigationDataStatusChanged();

      void onPropertyNavDataContextChanged();

      //void onPropertyNavDataUpdateAvailableScomoUpdateInfoChanged();

      void onPropertyNavDataUpdateComponentDeinstallResultChanged();

      void onPropertyNavDataUpdateFavoriteRegionSettingsResultChanged();

      void onPropertNavDataUpdateFavoriteRegionSettingsChanged();

      void onPropertyNavDataUpdateDeviceStatusChanged();

      void onPropertyNavDataUpdateCatalogueStatusChanged();

      void onPropertyUpdatePreparationStatusChanged();
      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_DiagFullUpdateViaUSBAckUpdMsg)
      ON_COURIER_MESSAGE(NAVDATAUPDATE_DiagFullUpdateViaUSBResultUpdMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const NAVDATAUPDATE_DiagFullUpdateViaUSBAckUpdMsg& oMsg);
      bool onCourierMessage(const NAVDATAUPDATE_DiagFullUpdateViaUSBResultUpdMsg& oMsg);

      class DeviceInfo
      {
         public:
            DeviceInfo()
               : _isValidDeviceType(false)
               , _isValidFullUpdate(false)
               , _validDeviceId(NAVDATA_DEVICEID__UNKNOWN)
            {}
            bool _isValidDeviceType;
            bool _isValidFullUpdate;
            uint32_t  _validDeviceId;
      };

   private:
      act_t _diagPerformFullUpdateViaUsbAct;
      act_t _getAvailableUpdatesAct;
      act_t _deleteUpdateComponentAct;
      act_t _setFavUpdateRegionAct;
      act_t _clearFavUpdateRegionAct;
      act_t _PerformFullUpdateViaUsbAct;
      act_t _PerformMapExportAct;
      DeviceInfo _deviceInfo;

      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationDataUpdateService);
};


#else // HALL_NAVIGATION_SERVICE

class HMIModelNavigationDataUpdateService : public HMIModelBase
{
   public:
      HMIModelNavigationDataUpdateService(navmiddleware::NavMiddleware& navMiddleware, InfoStore& infoStore) : HMIModelBase(navMiddleware, infoStore) {}
      virtual ~HMIModelNavigationDataUpdateService() {};

      virtual void initialize() {};
      virtual void deinitialize() {};

      // Incoming property updates from middleware
      PROPERTY_UPDATE_MIDDLEWARE_BEGIN()
      ON_PROPERTY_MIDDLEWARE_UNUSED()
      PROPERTY_UPDATE_MIDDLEWARE_END()

      // Incoming property updates from info store
      PROPERTY_UPDATE_INFOSTORE_BEGIN()
      ON_PROPERTY_INFOSTORE_UNUSED()
      PROPERTY_UPDATE_INFOSTORE_END()

      // Incoming courier messages from HMI
#pragma warning(disable : 4065)
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY() // LINT Info 764
      COURIER_MSG_MAP_END()

   private:
      FEATSTD_MAKE_CLASS_UNCOPYABLE(HMIModelNavigationDataUpdateService);
};


#endif // HALL_NAVIGATION_DATAUPDATE_SERVICE
#endif // HALL_TO_MDW_COM
#endif // _HMI_MODEL_NAVIGATION_DATAUPDATE_SERVICE_H
