/**************************************************************************************
* @file         : ActQueue.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (C) 2019-2020 Robert Bosch GmbH
*                 (C) 2019-2020 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef _ACT_QUEUE_H
#define _ACT_QUEUE_H


#include "asf/core/Types.h"
#include "asf/core/Timer.h"
#include <vector>


class ActQueue : public ::asf::core::TimerCallbackIF
{
   public:
      ActQueue();
      ~ActQueue();

      /**
       * push an ACT into the queue
       */
      void push(act_t act);

      /**
       * get the oldest ACT from the queue;
       * ATTENTION:
       * in case there are more than ACT_QUEUE_SIZE_MAX
       * ACTs in the queue, the exceeding requests are
       * responded immediately by the navi middleware;
       * in this case ACTs are returned from position
       * ACT_QUEUE_SIZE_MAX to retain the ACT order
       */
      act_t pop();

      /**
       * returns true, if the queue is empty;
       * otherwise returns false
       */
      bool empty();

      /**
       * timer callback - called when the processing time for
       * a request has exceeded ACT_QUEUE_REQUEST_TIMEOUT_MS;
       * this will erase all ACTs from the queue to ensure that
       * no unresponded ACTs remain in the queue
       */
      void onExpired(::asf::core::Timer& timer, ::boost::shared_ptr< ::asf::core::TimerPayload > data);

   private:
      act_t getAndRemoveAct(size_t pos);

      ::std::vector<act_t> _actQueue;
      ::asf::core::Timer _timer;
};


#endif
