/**************************************************************************************
* @file         : VehicleDimmingClientHandler.h
* @author       : CMC HMI Team
* @addtogroup   : apphmi_navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _VEHICLE_DIMMING_CLIENT_HANDLER_H_
#define _VEHICLE_DIMMING_CLIENT_HANDLER_H_

#include "dimming_main_fiProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/Util/HMIModelIncludes.h"


namespace App {
namespace Core {

class VehicleDimmingClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::dimming_main_fi::DIM_INFO_DimmingModeCallbackIF
{
   public:
      VehicleDimmingClientHandler(const std::string& vdDimFiPort);
      virtual ~VehicleDimmingClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onDIM_INFO_DimmingModeStatus(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
                                        const boost::shared_ptr< ::dimming_main_fi::DIM_INFO_DimmingModeStatus >& /*status*/);

      void onDIM_INFO_DimmingModeError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
                                       const boost::shared_ptr< ::dimming_main_fi::DIM_INFO_DimmingModeError >& /*error*/);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_END()

   private:
      ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy > _vdDimFiProxy;
};


}
}


#endif //_VD_DIMMING_CLIENT_HANDLER_H_
