/* ***************************************************************************************
* FILE:          HmiInfoServiceClientHandler.h
* SW-COMPONENT:  HMI-NAVIGATION
*  DESCRIPTION:  HmiInfoServiceClientHandler.h
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef _HMIINFOSERVICECLIENTHANDLER_H_
#define _HMIINFOSERVICECLIENTHANDLER_H_

#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "AppHmi_NavigationMessages.h"
#include "AppBase/ServiceAvailableIF.h"


/**
 *  Classes Declaration
 */

using namespace std;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
#include "asf/core/Types.h"

namespace App {
namespace Core {

class HmiInfoServiceClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public SetNavigationModeCallbackIF
   , public ETAAvailableCallbackIF
{
   public:
      virtual ~HmiInfoServiceClientHandler();
      static HmiInfoServiceClientHandler* getInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SetVehicleProfileType)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const SetVehicleProfileType& oMsg);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      void onSetNavigationModeError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetNavigationModeError >& error) {}
      void onSetNavigationModeResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< SetNavigationModeResponse >& response) {}

      void onETAAvailableError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableError >& error);
      void onETAAvailableUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableUpdate >& update);

   private:
      HmiInfoServiceClientHandler();

      static HmiInfoServiceClientHandler* _hmiInfoServiceClientHandler;
      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
};


}
}


#endif  // _HMIINFOSERVICECLIENTHANDLER_H_
