/* ***************************************************************************************
* FILE:          HmiInfoServiceClientHandler.cpp
* SW-COMPONENT:  HMI-COMMON
*  DESCRIPTION:  HmiInfoServiceClientHandler.cpp
*    COPYRIGHT:  (c) 2015-2016 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "hall_std_if.h"
#include "HmiInfoServiceClientHandler.h"

using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_NAVIGATION_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_NAVIGATION
#define ETG_I_TTFIS_CMD_PREFIX "APPHMI_NAVIGATION_"
#define ETG_I_FILE_PREFIX App::Core::HmiInfoServiceClientHandler::
#include "trcGenProj/Header/HmiInfoServiceClientHandler.cpp.trc.h"
#endif

using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;

#define COACH_PROFILE 0

namespace App {
namespace Core {


HmiInfoServiceClientHandler* HmiInfoServiceClientHandler::_hmiInfoServiceClientHandler = NULL;


HmiInfoServiceClientHandler::HmiInfoServiceClientHandler() : _hmiInfoServiceProxyClient(HmiInfoServiceProxy::createProxy("hmiinfoservicePort", *this))
{
   ETG_TRACE_USR1(("HmiInfoServiceClientHandler: CTOR"));
}


HmiInfoServiceClientHandler::~HmiInfoServiceClientHandler()
{
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler:: DTOR"));
   if (NULL != _hmiInfoServiceClientHandler)
   {
      delete _hmiInfoServiceClientHandler;
      _hmiInfoServiceClientHandler = NULL;
   }
}


HmiInfoServiceClientHandler* HmiInfoServiceClientHandler::getInstance()
{
   if (NULL == _hmiInfoServiceClientHandler)
   {
      _hmiInfoServiceClientHandler = new HmiInfoServiceClientHandler();
   }
   return _hmiInfoServiceClientHandler;
}


void HmiInfoServiceClientHandler::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler::onAvailable()"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
   if (NULL != _hmiInfoServiceProxyClient)
   {
      _hmiInfoServiceProxyClient->sendETAAvailableRegister(*this);
   }
}


void HmiInfoServiceClientHandler::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler::onUnavailable()"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
   if (NULL != _hmiInfoServiceProxyClient)
   {
      _hmiInfoServiceProxyClient->sendETAAvailableDeregisterAll();
   }
}


void HmiInfoServiceClientHandler::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("HmiInfoServiceClientHandler::registerProperties"));
   if (NULL != _hmiInfoServiceProxyClient)
   {
      _hmiInfoServiceProxyClient->sendETAAvailableRegister(*this);
   }
}


void HmiInfoServiceClientHandler::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_COMP(("HmiInfoServiceClientHandler::deregisterProperties"));
   if (NULL != _hmiInfoServiceProxyClient)
   {
      _hmiInfoServiceProxyClient->sendETAAvailableDeregisterAll();
   }
}


bool HmiInfoServiceClientHandler::onCourierMessage(const SetVehicleProfileType& oMsg)
{
   int value = oMsg.GetValue();
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler::onCourierMessage(SetVehicleProfileType(%d))", value));
   if (value == COACH_PROFILE)
   {
      _hmiInfoServiceProxyClient->sendSetNavigationModeRequest(*this, false, true);
   }
   else
   {
      _hmiInfoServiceProxyClient->sendSetNavigationModeRequest(*this, true, false);
   }
   return true;
}


void HmiInfoServiceClientHandler::onETAAvailableError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableError >& error)
{
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler::onETAAvailableError"));
}


void HmiInfoServiceClientHandler::onETAAvailableUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableUpdate >& update)
{
   ETG_TRACE_USR4(("HmiInfoServiceClientHandler::onETAAvailableUpdate"));
   bool ETAAvailableStatus = update->getETAAvailable();
   POST_MSG((COURIER_MESSAGE_NEW(ETAAvailableUpdateMsg)(ETAAvailableStatus)));
}


}
}
