/**************************************************************************************
* @file         : DiagnosisServiceClientHandler.h
* @author       : CMC HMI Team
* @addtogroup   : apphmi_navigation
* @brief        :
* @copyright    : (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/


#ifndef DIAGNOSIS_SERVICECLIENTHANDLER_H
#define DIAGNOSIS_SERVICECLIENTHANDLER_H

#include "asf/core/BaseComponent.h"
#include "asf/core/ComponentFactory.h"
#include "Common/Util/HMIModelIncludes.h"
#include "org/bosch/cm/diagnosis/dbus/Diagnosis1/SystemSettings1Stub.h"

using namespace ::asf::core;
using namespace ::org::bosch::cm::diagnosis::dbus::Diagnosis1::SystemSettings1;

namespace App {
namespace Core {

struct PrepareResDiagMsgData
{
   std::string sysSetType;
};


struct ExecuteResDiagMsgData
{
   std::string sysSetType;
};


struct FinalizeResDiagMsgData
{
   std::string sysSetType;
};


class DiagnosisServiceClientHandler : public SystemSettings1Stub
{
   public:

      DiagnosisServiceClientHandler(const std::string& portName);
      virtual ~DiagnosisServiceClientHandler();

      void sendPrepareResponse(const int& response);
      void sendExecuteResponse(const int& response);
      void sendFinalizeResponse(const int& response);

      virtual void onPrepareSystemSettingRequest(const ::boost::shared_ptr< PrepareSystemSettingRequest >& request);
      virtual void onExecuteSystemSettingRequest(const ::boost::shared_ptr< ExecuteSystemSettingRequest >& request);
      virtual void onFinalizeSystemSettingRequest(const ::boost::shared_ptr< FinalizeSystemSettingRequest >& request);

      static DiagnosisServiceClientHandler* GetInstance();
      static void s_Intialize(const std::string& portName);
      static void s_Destrory();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_END()

   private:
      static DiagnosisServiceClientHandler* _diagnosisServiceClientHandler;

      void sendPrepareRequest(const PrepareResDiagMsgData&);
      void sendExecuteRequest(const ExecuteResDiagMsgData&);
      void sendFinalizeRequest(const FinalizeResDiagMsgData&);

      int prepareResponseReceived;
      int executeResponseReceived;
      int finalizeResponseReceived;

      /** Helper method to do restore factory settings */
      int restoreFactoryProduction();
      int restoreFactorySettingHMI();

      PrepareSystemSettingRequest& rObjPrepareSystemSettingRequest;
      ExecuteSystemSettingRequest& rObjExecuteSystemSettingRequest;
      FinalizeSystemSettingRequest& rObjFinalizeSystemSettingRequest;
};


}
}


#endif //DEFSETSERVICEBASE_HEADER
