/**************************************************************************************
* @file         : BTPhoneClientHandler.h
* @author       :
* @addtogroup   : AppHmi_Navigation
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef _BT_PHONE_CLIENT_HANDLER_H_
#define _BT_PHONE_CLIENT_HANDLER_H_

#include "MOST_Tel_FIProxy.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "Common/Util/HMIModelIncludes.h"

static const int MAX_NUM_CONNECTED_DEVICES = 2;

namespace App {
namespace Core {

class BTPhoneClientHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public ::MOST_Tel_FI::DialCallbackIF
   , public ::MOST_Tel_FI::ActivePhoneDeviceCallbackIF
   , public ::MOST_BTSet_FI::DeviceListExtendedCallbackIF
   , public ::MOST_BTSet_FI::ConnectBluetoothProfileCallbackIF
   , public ::MOST_BTSet_FI::DisconnectBluetoothProfileCallbackIF
   , public ::MOST_BTSet_FI::ServiceAvailableCallbackIF
{
   public:
      BTPhoneClientHandler(const std::string& btTelFiPort, const std::string& btSetFiPort);
      virtual ~BTPhoneClientHandler();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& statechange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onDialError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Tel_FI::DialError >& /*error*/);
      void onDialResult(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_Tel_FI::DialResult >& /*result*/);

      void onDeviceListExtendedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedError >& /*error*/);
      void onDeviceListExtendedStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const boost::shared_ptr< ::MOST_BTSet_FI::DeviceListExtendedStatus >& /*status*/);

      virtual void onDisconnectBluetoothProfileError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::DisconnectBluetoothProfileError >& /*error*/);
      virtual void onDisconnectBluetoothProfileResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /* proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::DisconnectBluetoothProfileResult >& result) ;

      virtual void onConnectBluetoothProfileError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::ConnectBluetoothProfileError >& error);
      virtual void onConnectBluetoothProfileResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::ConnectBluetoothProfileResult >& result);

      virtual void onActivePhoneDeviceError(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::ActivePhoneDeviceError >& error);
      virtual void onActivePhoneDeviceStatus(const ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_Tel_FI::ActivePhoneDeviceStatus >& status);

      virtual void onServiceAvailableError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy>& /*proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::ServiceAvailableError >& error);
      virtual void onServiceAvailableStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /*proxy*/, const ::boost::shared_ptr< ::MOST_BTSet_FI::ServiceAvailableStatus >& status);

      // Incoming courier messages from HMI
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(BTPhoneDialReqMsg)
      ON_COURIER_MESSAGE(StartStopBtTetheringReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const BTPhoneDialReqMsg& oMsg);
      bool onCourierMessage(const StartStopBtTetheringReqMsg& oMsg);

   private:
      void sendBTActiveDeviceUpdateMsg(bool isAvailable);
      void sendBTConnectedDeviceUpdateMsg(bool isConnected);
      void setPANProfileON(uint8 deviceHandle);
      void setPANProfileOFF();

      bool _isServiceAvailable;
      bool _isPANConnected;
      bool _isPANConnectionRequired;
      uint8 _panProfileDeviceHandle;
      uint8 _queuedDeviceHandleForPanRequest;
      uint8 _activeDeviceHandle;
      uint8 _connectedDeviceHandle[MAX_NUM_CONNECTED_DEVICES];
      ::boost::shared_ptr< ::MOST_Tel_FI::MOST_Tel_FIProxy > _btTelProxy;
      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy;
};


}
}


#endif // _BT_PHONE_CLIENT_HANDLER_H_
