/**************************************************************************************
* @file         : AudioSourceHandler.h
* @author       : ECG5-Atchuta Sashank Kappagantu
* @addtogroup   : AppHmi_navigation
* @brief        :
* @copyright    : (c) 2017-2018 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef AudioSourceHandler_h
#define AudioSourceHandler_h

#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h"
#include "org/genivi/audiomanager/CommandInterfaceProxy.h"
#include "App/Core/AudioClient/AudioClientHandler.h"

#define AUDIOMANAGER_COMMANDINTERFACE org::genivi::audiomanager::CommandInterface
#define MASTERAUDIOSERVICE_INTERFACE ::bosch::cm::ai::hmi::masteraudioservice

namespace App {
namespace Core {

class AudioSourceHandler
   : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedCallbackIF
   , public AUDIOMANAGER_COMMANDINTERFACE::SetVolumeCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::VolumeCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateCallbackIF
   , public MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateCallbackIF
{
   public:
      virtual ~AudioSourceHandler();
      AudioSourceHandler();
      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onActivateSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                         const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceError >& error);
      virtual void onActivateSourceResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActivateSourceResponse >& /*response*/);

      virtual void onDeactivateSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceError >& /*error*/);
      virtual void onDeactivateSourceResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::DeactivateSourceResponse >& /*response*/);

      virtual void onSourceListChangedError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedError >& /*error*/);
      virtual void onSourceListChangedSignal(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::SourceListChangedSignal >& signal);

      virtual void onGetSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListError >& /*error*/);
      virtual void onGetSourceListResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::GetSourceListResponse >& response);

      virtual void onActiveSourceError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceError >& /*error*/);
      virtual void onActiveSourceUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& /*proxy*/,
                                        const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceUpdate >& update);

      void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyError >& /*error*/);
      void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
                                              const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMainSinkSoundPropertyResponse >& /*response*/);

      virtual void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
            const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedError >& /*error*/);
      virtual void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy  >& /*proxy*/,
            const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MainSinkSoundPropertyChangedSignal >& signal);

      virtual void onSetVolumeError(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetVolumeError >& /*error*/);
      virtual void onSetVolumeResponse(const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy >& /*proxy*/,
                                       const ::boost::shared_ptr< AUDIOMANAGER_COMMANDINTERFACE::SetVolumeResponse >& /*response*/);

      virtual void onVolumeError(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties:: VolumeError >& /*error*/);

      virtual void onVolumeUpdate(const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr<MASTERAUDIOSERVICE_INTERFACE::SoundProperties:: VolumeUpdate >& update);

      virtual void onMuteStateError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateError >& /*error*/);
      virtual void onMuteStateUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::MuteStateUpdate >& update);

      virtual void onSetMuteStateError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateError >& /*error*/);
      virtual void onSetMuteStateResponse(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy >& /*proxy*/, const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SetMuteStateResponse >& response);

      virtual void onActiveSourceListError(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                           const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListError >& error);
      virtual void onActiveSourceListUpdate(const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy >& proxy,
                                            const ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::ActiveSourceListUpdate >& signal);

      static AudioSourceHandler* getInstance();
      void requestSourceActivation(int32 SrcID, int32 SubSrcID);
      void setCurrentDeviceTag(int8 u8CurrentDeviceTag);
      int8 getCurrentDeviceTag();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_CASE_DUMMY_ENTRY()
      COURIER_MSG_MAP_END()

   private :
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::AudioSourceChange::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr< MASTERAUDIOSERVICE_INTERFACE::SoundProperties::SoundPropertiesProxy > _soundPropertiesProxy;
      ::boost::shared_ptr < AUDIOMANAGER_COMMANDINTERFACE::CommandInterfaceProxy > _commandIFProxy;

      static  AudioSourceHandler* _audioSourceHandler;
      int32 m_u32RequestedSubSrcId;
      int8 m_u8CurrentDeviceTag;
};


} // namespace Core
} // namespace App
#endif
