/****************************************************************************
* Copyright (c) 2018-2019 Robert Bosch Car Multimedia GmbH
* duplication and disclosure to third parties is prohibited.
*
* FILE                : NaviApplicationSwitchClientHandler.h
* COMPONENT Name      : NaviApplicationSwitchClientHandler
* DESCRIPTION         : DBus client for Application switch intrerface.
* AUTHOR              : Tejas B V
* Date                : 23.08.2017
* Revision History    : 0.1
* Date 23.08.2017     : Initial version
****************************************************************************/

#ifndef NAVI_APPLICATIONSWITCH_CLIENT_HANDLER
#define NAVI_APPLICATIONSWITCH_CLIENT_HANDLER
/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/
#define OSAL_S_IMPORT_INTERFACE_UTIL
#include "osal_if.h"

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "AppBase/ServiceAvailableIF.h"
#include "Common/Util/HMIModelIncludes.h"
#include "AppHmi_NavigationTypes.h"
#include "ApplicationSwitch.h"
#include "ApplicationSwitchProxy.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"

using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch;    //Change this

class NaviApplicationSwitchClientHandler : public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public RequestApplcationSwitchCallbackIF
   , public RequestShowHideWaitSceneCallbackIF
   , public ActivateDeactivateRVCSceneCallbackIF
   , public Mapout_Activate_DeactivateCallbackIF
   , public Mapout_activated_deactivatedCallbackIF
   , public Sig_ActivateContextCallbackIF
   , public ActiveRegionIdCallbackIF
{
   public:
      ApplicationSwitchClientComponent* _applicationSwitchClientComponent;
      NaviApplicationSwitchClientHandler(const std::string& portName);
      virtual ~NaviApplicationSwitchClientHandler();

      // static NaviApplicationSwitchClientHandler* poGetInstance();

      virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      virtual void onRequestApplcationSwitchError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchError >& error);
      virtual void onRequestApplcationSwitchResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestApplcationSwitchResponse >& response);

      virtual void onRequestShowHideWaitSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneError >& error);

      virtual void onRequestShowHideWaitSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< RequestShowHideWaitSceneResponse >& response);

      virtual void onActivateDeactivateRVCSceneError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneError >& error);

      virtual void onActivateDeactivateRVCSceneResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActivateDeactivateRVCSceneResponse >& response);

      virtual void onMapout_activated_deactivatedError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_activated_deactivatedError >& error);

      virtual void onMapout_activated_deactivatedResponse(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_activated_deactivatedResponse >& response);

      virtual void onMapout_Activate_DeactivateError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_Activate_DeactivateError >& error);

      virtual void onMapout_Activate_DeactivateSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Mapout_Activate_DeactivateSignal >& signal);

      virtual void onSig_ActivateContextError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextError >& error);

      virtual void onSig_ActivateContextSignal(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< Sig_ActivateContextSignal >& signal);

      virtual void onActiveRegionIdError(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdError >& error);

      virtual void onActiveRegionIdUpdate(const ::boost::shared_ptr< ApplicationSwitchProxy >& proxy, const ::boost::shared_ptr< ActiveRegionIdUpdate >& update);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_NAVIGATION_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ApplicationStateUpdMsg)
      ON_COURIER_MESSAGE(ContextSwitchReqMsg)
      ON_COURIER_MESSAGE(ValidateNaviEntryConditionReqMsg)
      ON_COURIER_MESSAGE(SendContextReqMsg)
      ON_COURIER_MESSAGE(MapOutStatusUpdMsg)
      ON_COURIER_MESSAGE(SwitchContextFromTrafficDetourReqMsg)
      ON_COURIER_MESSAGE(SwitchContextFromNavDataUpdateReqMsg)
      COURIER_MSG_MAP_END()

      bool onCourierMessage(const ApplicationStateUpdMsg& oMsg);
      bool onCourierMessage(const ContextSwitchReqMsg& oMsg);
      bool onCourierMessage(const ValidateNaviEntryConditionReqMsg& oMsg);
      bool onCourierMessage(const SendContextReqMsg& oMsg);
      bool onCourierMessage(const MapOutStatusUpdMsg& oMsg);
      bool onCourierMessage(const SwitchContextFromTrafficDetourReqMsg& oMsg);
      bool onCourierMessage(const SwitchContextFromNavDataUpdateReqMsg& oMsg);
   private:
      NaviApplicationSwitchClientHandler();
      enContextSwitchFromType _contextFromApp;
      enContextSwitchToType   _contextToApp;
      enContextSwitchFromType _activeContextID;
      enContextSwitchFromType _lastActiveContextID;
      enActivityIDs _currentActiveNaviContext;
      bool _isServiceCallBackReceived;
      bool _isDisclaimerConfirmed;
      bool _isNavAppForeground;
      bool _isTrafficDetourContextSwitchWithinApp;
      bool _isTrafficDetourDisplayValid;
      //static NaviApplicationSwitchClientHandler* m_poSelfAppSwitchClient;
      ::boost::shared_ptr<ApplicationSwitchProxy> m_poApplicationSwitchClient;
      bool checkIsNaviContext(const enActivityIDs& targetActivityID);
      void displayNaviContextScene(enActivityIDs& targetActivityID);
};


#endif
