/* ***************************************************************************************
* FILE:          CGIAppViewFactory.cpp
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewFactory.cpp is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "CGIAppViewFactory.h"
#include "AppHmi_MediaMessages.h"
// the views
#include "CGIAppViewController_Media.h"


SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_SourceSelection_Media),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_SourceSelection_Media_woNAV),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_USB),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_OPT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_OPT_woRDS),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_BT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Title),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Artist_Album),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Artist_Album_Title),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Genre_AllAlbums),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Genre_Artist),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Genre_Artist_Album),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Genre_Title),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Folder_File),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Audiobook_Chapter),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Playlist_Title),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Podcast_Episode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_VideoEpisode),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_VideoPlayer),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_VideoPlayer_FullScreen),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_ExternalDVD),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_ExternalDVD_FullScreen),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_AUX),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Album),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Album_External),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Artist),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Folder),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Genre),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Playlist),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Podcast),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Audiobook),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Video),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_AppleDevice),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_SD),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Album_Title),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_IPOD_BT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaMessage),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaConfirmBTPairing),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Sys_Popup),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER__GADGET_MEDIA),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_MASTER__GADGET_MEDIA_CABIN_ONLY),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_VideoDisableMessage),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_CAMPORTHDMI_1),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_CAMPORTHDMI_2),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_CAMPORTHDMI_3),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_WMA_DRM_ProtectedFileMessage),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_Video_DummyScene),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_WaitScene),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaUnsupportedPopupMessage),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaUnsupportedPopupMessageHUB),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaBTStreamingUnavailable),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaGlassUnavailableMessage),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_NoPlayableContentPopup),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_USBCAMERAPORT),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaDB_Download_Error),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_M_USBROUTER),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaDB_Download_Successful),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_SignalRangeError),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_Pfo_MediaDB_Download_Failure),
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
}


void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}
