/* ***************************************************************************************
* FILE:          CGIAppViewController_Media.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppViewController_Media.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#if !defined (_CGIAPPVIEWCONTROLLER_MEDIA_H)
#define _CGIAPPVIEWCONTROLLER_MEDIA_H

#include "CgiExtensions/ViewControllerBase.h"

#define SIMPLE_CONTROLLER(tController)\
		class tController : public ViewControllerBase\
								{\
		private:\
				courier_messages:\
		COURIER_MSG_MAP_BEGIN(0)\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()\
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()\
      COURIER_MSG_MAP_ENDS()\
		public:\
		tController() {}\
		virtual ~tController() {}\
		static const char* _name;\
		static Courier::ViewController* createInstance()\
								{\
			return COURIER_NEW(tController)();\
								}\
								};

SIMPLE_CONTROLLER(CGIAppViewController_M_SourceSelection_Media)
SIMPLE_CONTROLLER(CGIAppViewController_M_SourceSelection_Media_woNAV)
SIMPLE_CONTROLLER(CGIAppViewController_M_USB)
SIMPLE_CONTROLLER(CGIAppViewController_M_OPT)
SIMPLE_CONTROLLER(CGIAppViewController_M_OPT_woRDS)
SIMPLE_CONTROLLER(CGIAppViewController_M_BT)
SIMPLE_CONTROLLER(CGIAppViewController_M_Title)
SIMPLE_CONTROLLER(CGIAppViewController_M_Artist_Album)
SIMPLE_CONTROLLER(CGIAppViewController_M_Artist_Album_Title)
SIMPLE_CONTROLLER(CGIAppViewController_M_Genre_AllAlbums)
SIMPLE_CONTROLLER(CGIAppViewController_M_Genre_Artist)
SIMPLE_CONTROLLER(CGIAppViewController_M_Genre_Artist_Album)
SIMPLE_CONTROLLER(CGIAppViewController_M_Genre_Title)
SIMPLE_CONTROLLER(CGIAppViewController_M_Folder_File)
SIMPLE_CONTROLLER(CGIAppViewController_M_Audiobook_Chapter)
SIMPLE_CONTROLLER(CGIAppViewController_M_Playlist_Title)
SIMPLE_CONTROLLER(CGIAppViewController_M_Podcast_Episode)
SIMPLE_CONTROLLER(CGIAppViewController_M_VideoEpisode)
SIMPLE_CONTROLLER(CGIAppViewController_M_VideoPlayer)
SIMPLE_CONTROLLER(CGIAppViewController_M_VideoPlayer_FullScreen)
SIMPLE_CONTROLLER(CGIAppViewController_M_ExternalDVD)
SIMPLE_CONTROLLER(CGIAppViewController_M_ExternalDVD_FullScreen)
SIMPLE_CONTROLLER(CGIAppViewController_M_AUX)
SIMPLE_CONTROLLER(CGIAppViewController_M_Album)
SIMPLE_CONTROLLER(CGIAppViewController_M_Album_External)
SIMPLE_CONTROLLER(CGIAppViewController_M_Artist)
SIMPLE_CONTROLLER(CGIAppViewController_M_Folder)
SIMPLE_CONTROLLER(CGIAppViewController_M_Genre)
SIMPLE_CONTROLLER(CGIAppViewController_M_Playlist)
SIMPLE_CONTROLLER(CGIAppViewController_M_Podcast)
SIMPLE_CONTROLLER(CGIAppViewController_M_Audiobook)
SIMPLE_CONTROLLER(CGIAppViewController_M_Video)
SIMPLE_CONTROLLER(CGIAppViewController_M_AppleDevice)
SIMPLE_CONTROLLER(CGIAppViewController_M_SD)
SIMPLE_CONTROLLER(CGIAppViewController_M_Album_Title)
SIMPLE_CONTROLLER(CGIAppViewController_M_IPOD_BT)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaMessage)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaConfirmBTPairing)
SIMPLE_CONTROLLER(CGIAppViewController_Sys_Popup)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER__GADGET_MEDIA)
SIMPLE_CONTROLLER(CGIAppViewController_MASTER__GADGET_MEDIA_CABIN_ONLY)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_VideoDisableMessage)
SIMPLE_CONTROLLER(CGIAppViewController_M_CAMPORTHDMI_1)
SIMPLE_CONTROLLER(CGIAppViewController_M_CAMPORTHDMI_2)
SIMPLE_CONTROLLER(CGIAppViewController_M_CAMPORTHDMI_3)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_WMA_DRM_ProtectedFileMessage)
SIMPLE_CONTROLLER(CGIAppViewController_M_Video_DummyScene)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaGlassUnavailableMessage)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_WaitScene)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaUnsupportedPopupMessage)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaUnsupportedPopupMessageHUB)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaBTStreamingUnavailable)
SIMPLE_CONTROLLER(CGIAppViewController_M_USBCAMERAPORT)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_NoPlayableContentPopup)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaDB_Download_Error)
SIMPLE_CONTROLLER(CGIAppViewController_M_USBROUTER)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaDB_Download_Successful)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_SignalRangeError)
SIMPLE_CONTROLLER(CGIAppViewController_Pfo_MediaDB_Download_Failure)

#endif // _CGIAPPVIEWCONTROLLER_MEDIA_H
