/**************************************************************************************
* @file         : MediaDataPoolConfig.h
* @author       : ECV2-AGN7KOR
* @addtogroup   : AppHmi_Tuner
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MEDIA_DATAPOOLCONFIG_H_
#define MEDIA_DATAPOOLCONFIG_H_

#include "asf/core/Types.h"
#ifdef DP_DATAPOOL_ID
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_hmi_04_if.h"
#endif


/**
 * class MediaDataPoolConfig
 * This class hold implementation related to Datapool elements. It provides interfaces to read/write DP elements
 */
class MediaDataPoolConfig
{
   public:
      /**
       * Destructor of class DataPoolConfig
       * @return None
       */

      virtual ~MediaDataPoolConfig();
      /**
      * Singleton Class. Method to retrieve the instance of the class
      * @return Returns instance of the class
      */
      static MediaDataPoolConfig* getInstance();
      void setLastActiveCamportUSBSource(const tU32 camportUSBSourceId);
      tU32 getLastActiveCamportUSBSource();
      void setLastActiveRouterUSBSource(const tU32 routerUSBSourceId);
      tU32 getLastActiveRouterUSBSource();

   private:

      // Instance of the class
      static MediaDataPoolConfig* _dpMedia;

      MediaDataPoolConfig();
      MediaDataPoolConfig(const MediaDataPoolConfig&);
      MediaDataPoolConfig& operator=(const MediaDataPoolConfig&);
};


#endif /* DATAPOOLCONFIG_H_ */
